@extends('admin.layouts.master')

@push('css')

@endpush

@section('page-title')
    @include('admin.components.page-title',['title' => __($page_title)])
@endsection

@section('breadcrumb')
    @include('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ]
    ], 'active' => __("Fees & Charges")])
@endsection

@section('content')
{{-- //user fees and charges --}}
    <div class="custom-card mb-10">
        <div class="card-body">
            <h5 class=" text-center mb-0">{{ __("User Fees & Charges")  }}</h5>
        </div>
    </div>
    @foreach ($transaction_charges ?? [] as $item)
        @include('admin.components.trx-settings-charge-block',[
            'route'         => setRoute('admin.trx.settings.charges.update'),
            'title'         => $item->title,
            'data'          => $item,
        ])
    @endforeach
{{-- //agent fees and charges --}}
    <div class="custom-card mb-10">
        <div class="card-body">
            <h5 class=" text-center mb-0">{{ __("Agent Fees & Charges")  }}</h5>
        </div>
    </div>
    @foreach ($agent_transaction_charges ?? [] as $item)
        @include('admin.components.trx-settings-charge-block',[
            'route'         => setRoute('admin.trx.settings.charges.update'),
            'title'         => $item->title,
            'data'          => $item,
        ])
    @endforeach
{{-- //Merchant fees and charges --}}
    <div class="custom-card mb-10">
        <div class="card-body">
            <h5 class=" text-center mb-0">{{ __("Merchant Fees & Charges")  }}</h5>
        </div>
    </div>
    @foreach ($merchant_transaction_charges ?? [] as $item)
        @include('admin.components.trx-settings-charge-block',[
            'route'         => setRoute('admin.trx.settings.charges.update'),
            'title'         => $item->title,
            'data'          => $item,
        ])
    @endforeach
@endsection

@push('script')

@endpush
