
<div class="sidebar">
    <div class="sidebar-inner">
        <div class="sidebar-menu-inner-wrapper">
            <div class="sidebar-logo">
                <a href="<?php echo e(setRoute('index')); ?>" class="sidebar-main-logo">
                    <img src="<?php echo e(get_logo_merchant($basic_settings)); ?>" data-white_img="<?php echo e(get_logo_merchant($basic_settings,"dark")); ?>"
                    data-dark_img="<?php echo e(get_logo_merchant($basic_settings)); ?>" alt="logo">
                </a>
                <button class="sidebar-menu-bar">
                    <i class="fas fa-exchange-alt"></i>
                </button>
            </div>
            <div class="sidebar-menu-wrapper">
                <ul class="sidebar-menu">
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('merchant.dashboard')); ?>">
                            <i class="menu-icon fas fa-th-large"></i>
                            <span class="menu-title"><?php echo e(__("Dashboard")); ?></span>
                        </a>
                    </li>
                    <?php if(module_access('merchant-receive-money',$module)->status): ?>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('merchant.receive.money.index')); ?>">
                            <i class="menu-icon fas fa-receipt"></i>
                            <span class="menu-title"><?php echo e(__("Receive Money")); ?></span>

                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if(module_access('merchant-pay-link',$module)->status): ?>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(route('merchant.payment-link.index')); ?>">
                            <i class="menu-icon fas fa-link"></i>
                            <span class="menu-title"><?php echo e(__('pay Link')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if(module_access('merchant-withdraw-money',$module)->status): ?>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('merchant.withdraw.index')); ?>">
                            <i class="menu-icon fas fa-arrow-alt-circle-right"></i>
                            <span class="menu-title"><?php echo e(__("withdraw")); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('merchant.transactions.index')); ?>">
                            <i class="menu-icon fas fa-arrows-alt-h"></i>
                            <span class="menu-title"><?php echo e(__("Transactions")); ?></span>
                        </a>
                    </li>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('merchant.security.google.2fa')); ?>">
                            <i class="menu-icon fas fa-qrcode"></i>
                            <span class="menu-title"><?php echo e(__("2FA Security")); ?></span>
                        </a>
                    </li>
                    <?php if(module_access('merchant-api-key',$module)->status): ?>
                        <?php if(auth()->user()->developerApi ): ?>
                            <li class="sidebar-menu-item">
                                <a href="<?php echo e(setRoute('merchant.developer.api.index')); ?>">
                                    <i class="menu-icon las la-key"></i>
                                    <span class="menu-title"><?php echo e(__("api Key")); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if(module_access('merchant-gateway-settings',$module)->status): ?>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('merchant.gateway.setting.index')); ?>">
                            <i class="menu-icon fas fa-tools"></i>
                            <span class="menu-title"><?php echo e(__("gateway Settings")); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(setRoute('merchant.support.ticket.index')); ?>">
                            <i class="menu-icon fas fa-headset"></i>
                            <span class="menu-title"><?php echo e(__("Support")); ?></span>
                        </a>
                    </li>
                    <li class="sidebar-menu-item">
                        <a href="javascript:void(0)" class="logout-btn">
                            <i class="menu-icon fas fa-sign-out-alt"></i>
                            <span class="menu-title"><?php echo e(__("Logout")); ?></span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
        <div class="sidebar-doc-box bg_img" data-background="<?php echo e(asset('public/frontend/')); ?>/images/element/support.jpg">
            <div class="sidebar-doc-icon mx-auto">
                <i class="las la-code"></i>
            </div>
            <div class="sidebar-doc-content">
                <h4 class="title text-center pb-20"><?php echo e(__("Integrate Payment Gateway?")); ?></h4>
                <div class="sidebar-doc-btn">
                    <a href="<?php echo e(setRoute('developer.index')); ?>" class="btn--base w-100"><?php echo e(__("developer API")); ?></a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('script'); ?>
    <script>
        $(".logout-btn").click(function(){
            var actionRoute =  "<?php echo e(setRoute('merchant.logout')); ?>";
            var target      = 1;
            var sureText = '<?php echo e(__("Are you sure to")); ?>';
            var message     = `${sureText} <strong><?php echo e(__("Logout")); ?></strong>?`;
            var logout = `<?php echo e(__("Logout")); ?>`;

            openAlertModal(actionRoute,target,message,logout,"POST");
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH E:\xampp-8.0.2\htdocs\qrpay\v4.5.0\full_project\resources\views/merchant/partials/side-nav.blade.php ENDPATH**/ ?>