

<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('user.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("user.dashboard"),
        ]
    ], 'active' => __("withdraw")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="body-wrapper">
    <div class="dashboard-area mt-10">
        <div class="dashboard-header-wrapper">
            <h3 class="title"><?php echo e(__(@$page_title)); ?></h3>
        </div>
    </div>
    <div class="row mb-30-none justify-content-center">
        <div class="col-lg-6 mb-30">
            <div class="dash-payment-item-wrapper">
                <div class="dash-payment-item active">
                    <div class="dash-payment-title-area">
                        <span class="dash-payment-badge">!</span>

                    </div>
                    <div class="dash-payment-body">
                        <form class="card-form" action="<?php echo e(setRoute("user.money.out.confirm.automatic")); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="gateway_name" value="<?php echo e(strtolower($gateway->name)); ?>">
                            <div class="row">
                                <div class="col-lg-12 form-group">
                                    <label for="bank_name"><?php echo e(__("select Bank")); ?> <span class="text-danger">*</span></label>
                                    <select name="bank_name" class="form--control select2-basic" required data-placeholder="<?php echo e(__("select Bank")); ?>" >
                                          <option disabled selected value=""><?php echo e(__("select Bank")); ?></option>
                                        <?php $__currentLoopData = $allBanks ??[]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($bank['code']); ?>"><?php echo e($bank['name']); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-lg-12 form-group">
                                    <label for="account_number"><?php echo e(__("account Number")); ?> <span class="text-danger">*</span></label>
                                    <input type="text" class="form--control check_bank number-input" id="account_number"  name="account_number" value="<?php echo e(old('account_number')); ?>" placeholder="account Number">
                                    <label class="exist text-start"></label>
                                </div>
                                <div class="col-xl-12 col-lg-12">
                                    <button type="submit" class="btn--base w-100 btn-loading withdraw " > <?php echo e(__("confirm")); ?>


                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6 mb-30">
            <div class="dash-payment-item-wrapper">
                <div class="dash-payment-item active">
                    <div class="dash-payment-title-area">
                        <span class="dash-payment-badge">!</span>
                        <h5 class="title"><?php echo e(__("Withdraw Money Information!")); ?></h5>
                    </div>
                    <div class="dash-payment-body">
                        <div class="preview-list-wrapper">
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-receipt"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Entered Amount")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="request-amount"><?php echo e(number_format(@$moneyOutData->amount,2 )); ?> <?php echo e(get_default_currency_code()); ?></span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-exchange-alt"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Exchange Rate")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="request-amount"><?php echo e(__("1")); ?> <?php echo e(get_default_currency_code()); ?> =  <?php echo e(number_format(@$moneyOutData->gateway_rate,2 )); ?> <?php echo e(@$moneyOutData->gateway_currency); ?></span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="lab la-get-pocket"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Conversion Amount")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="conversion"><?php echo e(number_format(@$moneyOutData->conversion_amount,2 )); ?> <?php echo e(@$moneyOutData->gateway_currency); ?></span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-battery-half"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Total Fees & Charges")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="fees"><?php echo e(number_format(@$moneyOutData->gateway_charge,2 )); ?> <?php echo e(@$moneyOutData->gateway_currency); ?></span>
                                </div>
                            </div>

                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-money-check-alt"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span class=""><?php echo e(__("Will Get")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="text--success "><?php echo e(number_format(@$moneyOutData->will_get,2 )); ?> <?php echo e(@$moneyOutData->gateway_currency); ?></span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-money-check-alt"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span class="last"><?php echo e(__("Total Payable")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="text--warning last"><?php echo e(number_format(@$moneyOutData->payable,2 )); ?> <?php echo e(get_default_currency_code()); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp-8.0.2\htdocs\qrpay\v4.6.0\full_project\resources\views/user/sections/money-out/automatic/flutterwave.blade.php ENDPATH**/ ?>