<?php
    $defualt = get_default_language_code()??'en';
    $default_lng = 'en';
?>

<?php $__env->startPush('css'); ?>
    <style>
        card-errors {
            height: 20px;
            padding: 4px 0;
            color: #fa755a;
        }

        #stripe-token-handler {
            position: absolute;
            top: 0;
            left: 25%;
            right: 25%;
            padding: 20px 30px;
            border-radius: 0 0 4px 4px;
            box-sizing: border-box;
            box-shadow: 0 50px 100px rgba(50, 50, 93, 0.1),
                0 15px 35px rgba(50, 50, 93, 0.15),
                0 5px 15px rgba(0, 0, 0, 0.1);
            -webkit-transition: all 500ms ease-in-out;
            transition: all 500ms ease-in-out;
            transform: translateY(0);
            opacity: 1;
            background-color: white;
        }

        #stripe-token-handler.is-hidden {
            opacity: 0;
            transform: translateY(-80px);
        }

        #card-element {
            background-color: white;
            padding: 10px 12px;
            border-radius: 4px;
            border: 1px solid transparent;
            -webkit-transition: box-shadow 150ms ease;
            transition: box-shadow 150ms ease;
            height: 45px;
            line-height: 45px;
            font-weight: 500;
            border: 1px solid #e5e5e5;
            font-size: 14px;
            color: #425466;
            padding: 13px 15px;
            width: 100%;
        }

        #card-element--focus {
            border: 1px solid #5b39c9;
        }

        #card-element--invalid {
            border-color: #fa755a;
        }

        #card-element--webkit-autofill {
            background-color: #fefde5 !important;
        }
        @media only screen and (max-width: 1199px) {
            .payment-preview-wrapper{
                width: 1000px;
            }
        }
        @media only screen and (max-width: 991px) {
            .payment-preview-wrapper{
                width: 100%;
            }
            .payment-share-wrapper .payment-preview-box{
                display: block;
            }
        }


    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="custom-card payment-card ptb-30">
    <div class="payment-preview-wrapper payment-share-wrapper">
        <form id="payment-form" action="<?php echo e(setRoute('payment-link.submit')); ?>" method="POST">
            <div class="payment-preview-box">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="target" value="<?php echo e($payment_link->id); ?>">
                <input type="hidden" name="token">
                <input type="hidden" name="last4_card">
                <input type="hidden" name="payment_type">

                <div class="payment-preview-box-left">
                    <span class="sub-title"><i class="lab la-windows"></i> <?php echo e(@$payment_link->title); ?>


                        <?php if(@$payment_link->type == 'sub'): ?>
                            (<?php echo e(@$payment_link->qty); ?>)
                        <?php endif; ?>
                    </span>
                    <?php if($payment_link->type == 'pay' && !empty($payment_link->details)): ?>
                        <p><?php echo e($payment_link->details); ?></p>
                    <?php endif; ?>
                    <div class="form-group">
                        <label><?php echo e(__('price')); ?></label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><?php echo e(@$payment_link->currency_symbol); ?></span>
                            </div>

                            <?php if(@$payment_link->type == 'sub'): ?>
                                <input type="integer" name="amount" class="form--control" value="<?php echo e($payment_link->amountValue); ?>" placeholder="0.00" readonly>
                            <?php else: ?>
                                <?php if($payment_link->limit == 1): ?>
                                    <input type="integer" name="amount" class="form--control" value="<?php echo e(number_format($payment_link->min_amount, 2, '.', '')); ?>" placeholder="0.00">
                                <?php else: ?>
                                    <input type="integer" name="amount" class="form--control" value="" placeholder="0.00">
                                <?php endif; ?>
                            <?php endif; ?>


                        </div>
                        <?php if($payment_link->type ==  payment_gateway_const()::LINK_TYPE_PAY): ?>
                            <?php if($payment_link->limit == 1): ?>
                                <span class="limit-show"><?php echo e(get_amount($payment_link->min_amount, @$payment_link->currency)); ?> - <?php echo e(get_amount($payment_link->max_amount, @$payment_link->currency)); ?></span>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                    <?php if($payment_link->type ==  payment_gateway_const()::LINK_TYPE_PAY): ?>
                        <div class="payment-preview-thumb">
                            <?php if($payment_link->image): ?>
                                <img src="<?php echo e(get_image($payment_link->image,'payment-link-image')); ?>" alt="Link Image">
                            <?php else: ?>
                                <img src="<?php echo e(asset('public/frontend/images/logo/link_icon.png')); ?>" alt="Link Image">
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="payment-preview-box-right">
                    <?php if( $payLink->payment_gateway_status === true || $payLink->card_status === true || $payLink->wallet_status === true): ?>
                        <div class="row">
                            <div class="col-xl-12 form-group">
                                <input type="text" class="form--control" placeholder="<?php echo e(__('Full Name')); ?>" name="full_name" value="<?php echo e(old('full_name')); ?>" required>
                            </div>
                            <div class="col-xl-12 form-group">
                                <input type="email" class="form--control"  placeholder="<?php echo e(__('Email')); ?>" name="email" value="<?php echo e(old('email')); ?>" required>
                            </div>
                            <div class="col-xl-12 form-group">
                                <input type="text" class="form--control" name="phone" placeholder="<?php echo e(__('Phone')); ?>"  value="<?php echo e(old('phone')); ?>" required>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <div class="row <?php echo e($payLink->payment_gateway_status === false ? 'd-none':''); ?>">
                        <div class="col-xl-12 form-group">
                            <label class="or-title"><?php echo e(__('Pay With Payment Gateway')); ?></label>
                            <div class="payment-form-area">
                                <div class="payment-form-wrapper">
                                    <div class="paylink-radio-wrapper">
                                        <?php $__currentLoopData = $payment_gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="paylink-radio-item">
                                                <input type="radio" id="radio-<?php echo e($item->alias); ?>" name="payment_gateway" value="<?php echo e($item->alias); ?>">
                                                <label for="radio-<?php echo e($item->alias); ?>"><img src="<?php echo e(get_image($item->image, 'payment-gateways')); ?>" alt="gateway"></label>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                <div class="payment-hidden-form" style="display: none;">
                                    <div class="row">
                                        <div class="col-lg-6 form-group">
                                            <input type="text" class="form--control" placeholder="<?php echo e(__('card Holder Name')); ?>">
                                        </div>
                                        <div class="col-lg-6 form-group">
                                            <input type="number" class="form--control" placeholder="<?php echo e(__('card number')); ?>">
                                        </div>
                                        <div class="col-lg-6 form-group">
                                            <input type="text" class="form--control" placeholder="<?php echo e(__('Date')); ?>">
                                        </div>
                                        <div class="col-lg-6 form-group">
                                            <input type="password" class="form--control" placeholder="<?php echo e(__('CVV')); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    

                    <div class="row mb-30-none">
                        
                        <?php if(auth()->guard('web')->check()): ?>
                            <div class="col-xl-6 mb-30 <?php echo e($payLink->wallet_status === false ? 'd-none':''); ?>">
                                <label><?php echo e(__('Pay With')); ?> <?php echo e(@$basic_setting->site_name??"QRPAY"); ?> <?php echo e(__('wallet Balance')); ?></label>
                                <div class="payment-form-area">
                                    <div class="payment-form-wrapper">
                                        <div class="paylink-radio-wrapper">
                                                <div class="paylink-radio-item">
                                                    <input type="radio" id="radio-wallet" name="wallet_system" value="<?php echo e(get_default_currency_code()); ?>">
                                                    <label for="radio-wallet"><img src="<?php echo e(get_fav($basic_settings)); ?>" alt="<?php echo e(@$basic_setting->site_name??"QRPAY"); ?>"></label>
                                                </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php else: ?>
                        <div class="col-xl-6 mb-30 <?php echo e($payLink->wallet_status === false ? 'd-none' : ''); ?>">
                            <a href="javascript:void(0)" class="d-inline login-redirection">
                                <label><?php echo e(__('Pay With')); ?> <?php echo e(@$basic_setting->site_name??"QRPAY"); ?> <?php echo e(__('wallet Balance')); ?></label>
                                    <div class="payment-form-area">
                                        <div class="payment-form-wrapper">
                                            <div class="paylink-radio-wrapper">
                                                <div class="paylink-radio-item">
                                                    <input type="radio" id="" name="" value="<?php echo e(get_default_currency_code()); ?>">
                                                    <label for=""><img src="<?php echo e(get_fav($basic_settings)); ?>" alt="<?php echo e(@$basic_setting->site_name ?? "QRPAY"); ?>"></label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        <?php endif; ?>

                        
                        

                        <div class="col-xl-6 mb-30 <?php echo e($payLink->card_status === false ? 'd-none':''); ?>">
                            <label class="or-title"><?php echo e(__('Pay With A Debit/Credit Card')); ?></label>

                            <div class="payment-form-area">
                                <div class="payment-form-wrapper">
                                    <div class="paylink-radio-wrapper">
                                            <div class="paylink-radio-item">
                                                <input type="radio" id="radio-card_system" name="card_system" value="<?php echo e("card_system"); ?>">
                                                <label for="radio-card_system"><img src="<?php echo e(files_asset_path('default-card')); ?>" alt="card-image"></label>
                                            </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-12 form-group card_payment_area card-fields">
                            <input type="text" class="form--control" placeholder="<?php echo e(__('Name on card')); ?>" name="card_name" value="<?php echo e(old('card_name')); ?>" required>
                        </div>
                        <div class="col-xl-12 form-group card_payment_area card-fields">
                            <div id="card-element">
                            </div>
                        </div>
                    </div>
                       
                    <div class="row mt-20">
                        <?php if( $payLink->payment_gateway_status === true || $payLink->card_status === true || $payLink->wallet_status === true): ?>
                            <div class="col-xl-12 form-group ">
                                <div class="preview-secure-group">
                                    <img src="<?php echo e(asset('public/frontend/images/icon/100-percent.png')); ?>" alt="">
                                    <p><?php echo e(__('Securely save my information for 1-click checkout')); ?> <span><?php echo e(__('Pay faster on')); ?> <?php echo e(@$payment_link->user->address->company_name); ?> <?php echo e(__('and everywhere Link is accepted')); ?></span></p>
                                </div>
                            </div>
                            <div class="col-xl-12 form-group pt-10">
                                <button type="button" id="submit-button" class="btn--base w-100 btn-loading"><?php echo e(__('Pay')); ?></button>
                            </div>
                        <?php else: ?>
                        <h4 class="mb-0 text--warning text-center mt-2"><?php echo e(__("Currently,the Paylink system is unavailable.")); ?></h4>
                        <?php endif; ?>
                    </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush("script"); ?>
    <script src="https://js.stripe.com/v3/"></script>
    <script>
        $('.card-fields').addClass('d-none');
        $('.login-redirection').on('click', function(){
            window.location = "<?php echo e(setRoute('payment-link.user.wallet.login',$payment_link->token)); ?>";
        })
        $('input[name="payment_gateway"]').on('click', function(){
            $('#payment-form input[name="wallet_system"]').prop('checked', false);
            $('#payment-form input[name="card_system"]').prop('checked', false);
            $('.card-fields').addClass('d-none');
        })
        $('input[name="wallet_system"]').on('click', function(){
            $('#payment-form input[name="payment_gateway"]').prop('checked', false);
            $('#payment-form input[name="card_system"]').prop('checked', false);
            $('.card-fields').addClass('d-none');
        })
        $('input[name="card_system"]').on('click', function(){
            $('#payment-form input[name="payment_gateway"]').prop('checked', false);
            $('#payment-form input[name="wallet_system"]').prop('checked', false);
            $('.card-fields').removeClass('d-none');
        })
        $(document).ready(function () {
            $(document).on('click', function(event){
                if($(event.target).is(".card_payment_area, .card_payment_area *")){
                    $('#payment-form input[name="payment_gateway"]').prop('checked', false);
                    $('#payment-form input[name="wallet_system"]').prop('checked', false);
                }
            })

            $(document).on("click", handler);


        });

        // Create a Stripe client
        var stripe = Stripe('<?php echo e($public_key); ?>');
        // Create an instance of Elements
        var elements = stripe.elements();

        var style = {
            base: {
                color: '#32325d',
                lineHeight: '18px',
                fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
                fontSmoothing: 'antialiased',
                fontSize: '16px',
                '::placeholder': {
                color: '#425466'
                }
            },
            invalid: {
                color: '#fa755a',
                iconColor: '#fa755a'
            }
        };

        // Create an instance of the card Element
        var card = elements.create('card', {
            hidePostalCode: true,
            style: style
        });

        // Add an instance of the card Element into the `card-element` <div>
        card.mount('#card-element');

        // Handle real-time validation errors from the card Element.
        card.addEventListener('change', function(event) {
            var displayError = document.getElementById('card-errors');
            if (event.error) {
                displayError.textContent = event.error.message;
            } else {
                displayError.textContent = '';
            }
        });

        $('#submit-button').on('click', function () {
            $(this).prop("disabled",true);
            let payemnt_gateway = $('#payment-form input[name="payment_gateway"]:checked').val();
            let wallet_system = $('#payment-form input[name="wallet_system"]:checked').val();
            alert
            var form = document.getElementById('payment-form');
            event.preventDefault();

            if(payemnt_gateway == undefined && wallet_system == undefined){
                stripe.createToken(card).then(function(result) {
                    if (result.error) {
                        $('#submit-button').prop("disabled",false);
                        throwMessage('error',[result.error.message]);
                    } else {
                        $('#payment-form input[name="token"]').val(result.token.id);
                        $('#payment-form input[name="last4_card"]').val(result.token.card.last4);
                        $('#payment-form input[name="payment_type"]').val('card_payment');
                        if(result.token.id){
                            form.submit();
                        }else{
                            throwMessage('error',['<?php echo e(__("Something went wrong! Please try again.")); ?>']);
                        }
                    }
                });
            }else if(payemnt_gateway != undefined ){
                $('#payment-form input[name="payment_type"]').val('payment_gateway');
                form.submit();
            }else if(wallet_system != undefined ){
                $('#payment-form input[name="payment_type"]').val('wallet_payment');
                form.submit();
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp-8.0.2\htdocs\qrpay\v4.5.0\full_project\resources\views/frontend/paylink/share.blade.php ENDPATH**/ ?>