

<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title', ['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __('User Care'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="custom-card">
        <div class="card-header">
            <h6 class="title"><?php echo e(__("Edit KYC")); ?></h6>
        </div>
        <div class="card-body">
            <form class="card-form">
                <div class="row align-items-center mb-10-none">
                    <div class="col-xl-4 col-lg-4 form-group">
                        <ul class="user-profile-list-three">
                            <li class="bg--base one"><?php echo e(__("Full Name")); ?>: <span><?php echo e($user->fullname); ?></span></li>
                            <li class="bg--info two"><?php echo e(__("Username")); ?>: <span><?php echo e("@".$user->username); ?></span></li>
                            <li class="bg--success three"><?php echo e(__("Email")); ?>: <span><?php echo e($user->email); ?></span></li>
                            <li class="bg--warning four"><?php echo e(__("Status")); ?>: <span><?php echo e(__($user->stringStatus->value)); ?></span></li>
                            <li class="bg--danger five"><?php echo e(__("Last Login")); ?>: <span><?php echo e($user->lastLogin); ?></span></li>
                        </ul>
                    </div>
                    <div class="col-xl-4 col-lg-4 form-group">
                        <div class="user-profile-thumb">
                            <img src="<?php echo e($user->userImage); ?>" alt="user">
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 form-group">
                        <ul class="user-profile-list">
                            <li class="bg--danger one"><?php echo e(__('State')); ?>: <span><?php echo e($user->address->state ?? "-"); ?></span></li>
                            <li class="bg--warning two"><?php echo e(__('Phone Number')); ?>: <span><?php echo e($user->full_mobile); ?></span></li>
                            <li class="bg--success three"><?php echo e(__('Zip/Postal')); ?>: <span><?php echo e($user->address->zip ?? "-"); ?></span></li>
                            <li class="bg--info four"><?php echo e(__('City')); ?>: <span><?php echo e($user->address->city ?? "-"); ?></span></li>
                            <li class="bg--base five"><?php echo e(__('Country')); ?>: <span><?php echo e($user->address->country ?? "-"); ?></span></li>
                        </ul>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="custom-card mt-15">
        <div class="card-header">
            <h6 class="title"><?php echo e(__("Information of Logs")); ?></h6>
            <span class="<?php echo e($user->kycStringStatus->class); ?>"><?php echo e($user->kycStringStatus->value); ?></span>
            <?php echo $__env->make('admin.components.link.custom',[
                'href'          => setRoute('admin.users.details',$user->username),
                'text'          =>__( "Profile"),
                'class'         => "btn btn--base",
                'permission'    => "admin.users.details",
            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="card-body">
            <?php if($user->kyc != null && $user->kyc->data != null): ?>
                <ul class="product-sales-info">
                    <?php $__currentLoopData = $user->kyc->data ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($item->type == "file"): ?>
                            <?php
                                $file_link = get_file_link("kyc-files",$item->value);
                            ?>
                            <li>
                                <span class="kyc-title"><?php echo e($item->label); ?>:</span>
                                <?php if($file_link == false): ?>
                                    <span><?php echo e(__("File not found!")); ?></span>
                                    <?php continue; ?>
                                <?php endif; ?>

                                <?php if(its_image($item->value)): ?>
                                    <span class="product-sales-thumb">
                                        <a class="img-popup" data-rel="lightcase:myCollection" href="<?php echo e($file_link); ?>">
                                            <img src="<?php echo e($file_link); ?>" alt="<?php echo e($item->label); ?>">
                                        </a>
                                    </span>
                                <?php else: ?>
                                    <span class="text--danger">
                                        <?php
                                            $file_info = get_file_basename_ext_from_link($file_link);
                                        ?>
                                        <a href="<?php echo e(setRoute('file.download',["kyc-files",$item->value])); ?>" >
                                            <?php echo e(Str::substr($file_info->base_name ?? "", 0 , 20 ) ."..." . $file_info->extension ?? ""); ?>

                                        </a>
                                    </span>
                                <?php endif; ?>
                            </li>
                        <?php else: ?>
                            <li>
                                <span class="kyc-title"><?php echo e($item->label); ?>:</span>
                                <span><?php echo e($item->value); ?></span>
                            </li>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <div class="product-sales-btn">
                    <?php if($user->kyc_verified != global_const()::VERIFIED): ?>
                        <?php echo $__env->make('admin.components.button.custom',[
                            'type'          => "button",
                            'class'         => "approve-btn w-100",
                            'text'          => __("Approve"),
                            'permission'    => "admin.users.kyc.approve",
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>

                    <?php if($user->kyc_verified != global_const()::REJECTED): ?>
                        <?php echo $__env->make('admin.components.button.custom',[
                            'type'          => "button",
                            'class'         => "bg--danger reject-btn w-100",
                            'text'          => __("Reject"),
                            'permission'    => "admin.users.kyc.reject",
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <div class="alert alert-primary"><?php echo e(__("KYC Information not submitted yet")); ?></div>
            <?php endif; ?>
        </div>
    </div>

    <?php echo $__env->make('admin.components.modals.kyc-reject',compact("user"), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(".approve-btn").click(function(){
            var actionRoute = "<?php echo e(setRoute('admin.users.kyc.approve',$user->username)); ?>";
            var target      = "<?php echo e($user->username); ?>";
            var message     = `Are you sure to approve <?php echo e("@" . $user->username); ?> KYC information.`;
            openDeleteModal(actionRoute,target,message,"Approve","POST");
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/admin/sections/user-care/kyc-details.blade.php ENDPATH**/ ?>