<?php
    $lang = selectedLang();
    $service_slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::SERVICE_SECTION);
    $service = App\Models\Admin\SiteSections::getData( $service_slug)->first();
    $merchant_slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::MERCHANT_SECTION);
    $merchant = App\Models\Admin\SiteSections::getData( $merchant_slug)->first();
    $agent_info_slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::AGENT_SECTION);
    $agent_info = App\Models\Admin\SiteSections::getData( $agent_info_slug)->first();
?>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start service section
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<section class="service-section ptb-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-6 col-lg-8 col-md-10 text-center">
                <?php if( Route::currentRouteName() == 'merchant'): ?>
                <div class="section-header">
                    <span class="section-sub-titel"><i class="fas fa-qrcode"></i> <?php echo e(__(@$merchant->value->language->$lang->heading)); ?></span>
                    <h2 class="section-title"><?php echo e(__(@$merchant->value->language->$lang->sub_heading)); ?></h2>
                    <p><?php echo e(__(@$merchant->value->language->$lang->details)); ?></p>
                </div>
                <?php elseif(Route::currentRouteName() == 'agent'): ?>
                <div class="section-header">
                    <span class="section-sub-titel"><i class="fas fa-qrcode"></i> <?php echo e(__(@$agent_info->value->language->$lang->bottom_heading)); ?></span>
                    <h2 class="section-title"><?php echo e(__(@$agent_info->value->language->$lang->bottom_sub_heading)); ?></h2>
                    <p><?php echo e(__(@$agent_info->value->language->$lang->bottom_details)); ?></p>
                </div>
                <?php else: ?>
                <div class="section-header">
                    <span class="section-sub-titel"><i class="fas fa-qrcode"></i> <?php echo e(__(@$service->value->language->$lang->heading)); ?></span>
                    <h2 class="section-title"><?php echo e(__(@$service->value->language->$lang->sub_heading)); ?></h2>
                    <p><?php echo e(__(@$service->value->language->$lang->details)); ?></p>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="row justify-content-center mb-40-none">
            <?php if( Route::currentRouteName() == 'merchant'): ?>
                <?php if(isset($merchant->value->items)): ?>
                    <?php $__currentLoopData = $merchant->value->items ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-6 col-md-6 col-sm-6 mb-40">
                            <div class="service-item text-center">
                                <div class="service-icon">
                                    <i class="<?php echo e(@$item->language->$lang->icon); ?>"></i>
                                </div>
                                <div class="service-content">
                                    <h4 class="title"><?php echo e(@$item->language->$lang->title); ?></h4>
                                    <p><?php echo e(@$item->language->$lang->sub_title); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            <?php elseif(Route::currentRouteName() == 'agent'): ?>
                <?php if(isset($agent->value->items)): ?>
                    <?php $__currentLoopData = $agent->value->items ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-3 col-md-6 col-sm-6 mb-40">
                            <div class="service-item text-center">
                                <div class="service-icon">
                                    <i class="<?php echo e(@$item->language->$lang->icon); ?>"></i>
                                </div>
                                <div class="service-content">
                                    <h4 class="title"><?php echo e(@$item->language->$lang->title); ?></h4>
                                    <p><?php echo e(@$item->language->$lang->sub_title); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            <?php else: ?>
                <?php if(isset($service->value->items)): ?>
                    <?php $__currentLoopData = $service->value->items ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-3 col-md-6 col-sm-6 mb-40">
                            <div class="service-item text-center">
                                <div class="service-icon">
                                    <i class="<?php echo e(@$item->language->$lang->icon); ?>"></i>
                                </div>
                                <div class="service-content">
                                    <h4 class="title"><?php echo e(@$item->language->$lang->title); ?></h4>
                                    <p><?php echo e(@$item->language->$lang->sub_title); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>

            <?php endif; ?>

        </div>
    </div>
</section>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End service section
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/frontend/partials/service.blade.php ENDPATH**/ ?>