

<?php
$lang = selectedLang();
$system_default    = $default_language_code;
?>

<?php $__env->startSection('content'); ?>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start Blog
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<section class="blog-section style-01 ptb-120">
    <div class="container">
        <div class="row justify-content-center mb-30-none">
            <div class="col-xl-8 col-lg-7 mb-30">
                <div class="row justify-content-center mb-30-none">
                    <div class="col-xl-12 mb-30">
                        <div class="blog-item">
                            <div class="blog-thumb">
                                <img src="<?php echo e(get_image(@$blog->image,'blog')); ?>" alt="blog">
                                <span class="category"><?php echo e(@$blog->category->data->language->$lang->name??@$blog->category->data->language->$system_default->name); ?></span>
                            </div>
                            <div class="blog-content">
                                <h4 class="title mb-30"><a href="javascript:void(0)"><?php echo e(@$blog->name->language->$lang->name??@$blog->name->language->$system_default->name); ?></a></h4>
                                <?php
                                    echo @$blog->details->language->$lang->details??@$blog->details->language->$system_default->details;

                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-5 mb-30">
                <div class="blog-sidebar">
                    <div class="widget-box mb-30">
                        <h4 class="widget-title"><?php echo e(__("Categories")); ?></h4>
                        <div class="category-widget-box">
                            <ul class="category-list">
                                <?php $__currentLoopData = $categories ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $blogCount = App\Models\Blog::active()->where('category_id',$cat->id)->count();

                                ?>
                                    <?php if( $blogCount > 0): ?>
                                    <li><a href="<?php echo e(setRoute('blog.by.category',[$cat->id, slug(@$cat->name)])); ?>"> <?php echo e(__(@$cat->data->language->$lang->name??@$cat->data->language->$system_default->name)); ?><span><?php echo e(@$blogCount); ?></span></a></li>
                                    <?php else: ?>
                                    <li><a href="javascript:void(0)"> <?php echo e(__(@$cat->data->language->$lang->name??@$cat->data->language->$system_default->name)); ?><span><?php echo e(@$blogCount); ?></span></a></li>
                                    <?php endif; ?>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </ul>
                        </div>
                    </div>
                    <div class="widget-box mb-30">
                        <h4 class="widget-title"><?php echo e(__("Recent Posts")); ?></h4>
                        <div class="popular-widget-box">
                            <?php $__currentLoopData = $recentPost; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="single-popular-item d-flex flex-wrap align-items-center">
                                <div class="popular-item-thumb">
                                    <a href=" "><img src="<?php echo e(get_image(@$post->image,'blog')); ?>" alt="blog"></a>
                                </div>
                                <div class="popular-item-content">
                                    <span class="date"><?php echo e($post->created_at->diffForHumans()); ?></span>
                                    <h5 class="title"><a href="<?php echo e(route('blog.details',[$post->id, @$post->slug])); ?>"><?php echo e(@$post->name->language->$lang->name); ?></a></h5>

                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <div class="widget-box">
                        <h4 class="widget-title"><?php echo e(__("Tags")); ?></h4>

                        <div class="tag-widget-box">
                            <?php
                                $old_tags = $blog->lan_tags?->language?->$lang?->tags ?? $blog->lan_tags?->language?->$system_default?->tags ?? [];
                                if( gettype($old_tags) === "string"){
                                    $old_tags = json_decode( $old_tags,true);
                                }
                            ?>
                            <ul class="tag-list">
                                <?php $__currentLoopData = $old_tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a href="javascript:void(0)"><?php echo e(@$tag); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End Blog
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<?php $__env->stopSection(); ?>

<?php $__env->startPush("script"); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/frontend/blogDetails.blade.php ENDPATH**/ ?>