<table class="custom-table admin-search-table">
    <thead>
        <tr>
            <th></th>
            <th><?php echo e(__("Full Name")); ?></th>
            <th><?php echo e(__("Username")); ?></th>
            <th><?php echo e(__("Email")); ?></th>
            <th><?php echo e(__("Phone")); ?></th>
            <th><?php echo e(__("Role")); ?></th>
            <th><?php echo e(__("Status")); ?></th>
            <th></th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $admins ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr data-item="<?php echo e($item->editData); ?>">
                <td>
                    <ul class="user-list">
                        <li><img src="<?php echo e(get_image($item->image,"admin-profile")); ?>" alt="Profile"></li>
                    </ul>
                </td>
                <td><span><?php echo e($item->fullname); ?></span></td>
                <td><?php echo e($item->username); ?></td>
                <td><?php echo e($item->email); ?></td>
                <td><?php echo e($item->phone); ?></td>
                <td>
                    <?php if($item->roles->count() > 0): ?>
                            <?php if($item->isSuperAdmin()): ?>
                                <span class="text--danger"><?php echo e($item->getRolesString()); ?></span>
                            <?php else: ?>
                                <span class="text--primary"><?php echo e($item->getRolesString()); ?></span>
                            <?php endif; ?>
                    <?php endif; ?>
                </td>
                <td>
                    <?php if($item->isSuperAdmin()): ?>
                        <span class="badge badge--success"><?php echo e(__($item->stringStatus )); ?></span>
                    <?php else: ?>
                        <?php echo $__env->make('admin.components.form.switcher',[
                            'name'          =>__("Status"),
                            'value'         => $item->status,
                            'options'       => [__("active") => 1,__("Banned") => 0],
                            'onload'        => true,
                            'data_target'   => $item->username,
                            'permission'    => "admin.admins.admin.status.update",
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </td>
                <td>
                    <?php echo $__env->make('admin.components.link.info-default',[
                        'class'         => "edit-modal-button",
                        'permission'    => "admin.admins.admin.update",
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php if(!$item->isSuperAdmin()): ?>
                        <?php echo $__env->make('admin.components.link.delete-default',[
                            'class'         => "delete-modal-button",
                            'permission'    => "admin.admins.admin.delete",
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <?php echo $__env->make('admin.components.alerts.empty',['colspan' => 8], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
    </tbody>
</table>
<?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/admin/components/data-table/admin-table.blade.php ENDPATH**/ ?>