<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title', ['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __('Merchant Care'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-area">
    <div class="dashboard-item-area">
        <div class="row">
            <?php $__currentLoopData = $data['wallets']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wallet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-xxxl-4 col-xxl-4 col-xl-4 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e($wallet->currency->name); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e(get_amount($wallet->balance, $wallet->currency->code)); ?></h2>
                                </div>
                            </div>
                            <div class="right">
                                <div class="dashboard-icon">
                                    <i class="las la-wallet"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="row">
            <div class="col-xxxl-4 col-xxl-4 col-xl-4 col-lg-6 col-md-6 col-sm-12 mb-15">
                <div class="dashbord-item">
                    <div class="dashboard-content">
                        <div class="left">
                            <h6 class="title"><?php echo e(__("Total Transactions")); ?></h6>
                            <div class="user-info">
                                <h2 class="user-count"><?php echo e(get_amount($data['total_transaction'], get_default_currency_code())); ?></h2>
                            </div>
                        </div>
                        <div class="right">
                            <div class="dashboard-icon">
                                <i class="las la-sync-alt"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxxl-4 col-xxl-4 col-xl-4 col-lg-6 col-md-6 col-sm-12 mb-15">
                <div class="dashbord-item">
                    <div class="dashboard-content">
                        <div class="left">
                            <h6 class="title"><?php echo e(__("Total Money Out")); ?></h6>
                            <div class="user-info">
                                <h2 class="user-count"><?php echo e(get_amount($data['money_out_amount'], get_default_currency_code())); ?></h2>
                            </div>
                        </div>
                        <div class="right">
                            <div class="dashboard-icon">
                                <i class="las la-plus-circle"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <div class="custom-card mt-15">
        <div class="card-header">
            <h6 class="title"><?php echo e(__("Merchant Overview")); ?></h6>
        </div>
        <div class="card-body">
            <form class="card-form">
                <div class="row align-items-center mb-10-none">
                    <div class="col-xl-4 col-lg-4 form-group">
                        <div class="user-action-btn-area">
                            <div class="user-action-btn">
                                <?php echo $__env->make('admin.components.button.custom',[
                                    'type'          => "button",
                                    'class'         => "wallet-balance-update-btn bg--danger one",
                                    'text'          => __("Add/Subtract Balance"),
                                    'icon'          => "las la-wallet me-1",
                                    'permission'    => "admin.users.wallet.balance.update",
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="user-action-btn">
                                <?php echo $__env->make('admin.components.link.custom',[
                                    'href'          => setRoute('admin.merchants.login.logs',$user->username),
                                    'class'         => "bg--base two",
                                    'icon'          => "las la-sign-in-alt me-1",
                                    'text'          => __("Login Logs"),
                                    'permission'    => "admin.agents.login.logs",
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="user-action-btn">
                                <?php echo $__env->make('admin.components.link.custom',[
                                    'href'          => "#email-send",
                                    'class'         => "bg--base three modal-btn",
                                    'icon'          => "las la-mail-bulk me-1",
                                    'text'          => __("Send Email"),
                                    'permission'    => "admin.merchant.send.mail",
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="user-action-btn">
                                <?php echo $__env->make('admin.components.link.custom',[
                                    'class'         => "bg--base four login-as-member",
                                    'icon'          => "las la-user-check me-1",
                                    'text'          => __("Login as Member"),
                                    'permission'    => "admin.merchants.login.as.member",
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="user-action-btn">
                                <?php echo $__env->make('admin.components.link.custom',[
                                    'href'          => setRoute('admin.merchants.mail.logs',$user->username),
                                    'class'         => "bg--base five",
                                    'icon'          => "las la-history me-1",
                                    'text'          => __("Email Logs"),
                                    'permission'    => "admin.merchants.mail.logs",
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 form-group">
                        <div class="user-profile-thumb">
                            <img src="<?php echo e($user->userImage); ?>" alt="user">
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 form-group">
                        <ul class="user-profile-list">
                            <li class="bg--base one"><?php echo e(__("Full Name")); ?>: <span><?php echo e($user->fullname); ?></span></li>
                            <li class="bg--info two"><?php echo e(__("Username")); ?>: <span><?php echo e("@".$user->username); ?></span></li>
                            <li class="bg--success three"><?php echo e(__("Email")); ?>: <span><?php echo e($user->email); ?></span></li>
                            <li class="bg--warning four"><?php echo e(__("Status")); ?>: <span><?php echo e(__($user->stringStatus->value)); ?></span></li>
                            <li class="bg--danger five"><?php echo e(__("Last Login")); ?>: <span><?php echo e($user->lastLogin); ?></span></li>
                        </ul>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="custom-card mt-15">
        <div class="card-header">
            <h6 class="title"><?php echo e(__("Information of Merchant")); ?></h6>
        </div>
        <div class="card-body">
            <form class="card-form" method="POST" action="<?php echo e(setRoute('admin.merchants.details.update',$user->username)); ?>">
                <?php echo csrf_field(); ?>
                <div class="row mb-10-none">
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input',[
                            'label'         => __("first Name")."*",
                            'name'          => "firstname",
                            'value'         => old("firstname",$user->firstname),
                            'attribute'     => "required",
                            'placeholder'   => __( "Write Here.."),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input',[
                            'label'         => __("last Name")."*",
                            'name'          => "lastname",
                            'value'         => old("lastname",$user->lastname),
                            'attribute'     => "required",
                            'placeholder'   => __( "Write Here.."),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label><?php echo e(__("phone Number")); ?><span>*</span></label>
                        <div class="input-group">
                            <div class="input-group-text phone-code">+<?php echo e($user->mobile_code); ?></div>
                            <input class="phone-code" type="hidden" name="mobile_code" value="<?php echo e($user->mobile_code); ?>" />
                            <input type="text" class="form--control" placeholder="<?php echo e(__( "Write Here..")); ?>" name="mobile" value="<?php echo e(old('mobile',$user->mobile)); ?>">
                        </div>
                        <?php $__errorArgs = ["mobile"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback d-block" role="alert">
                                <strong><?php echo e($message); ?></strong>
                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input',[
                           'label'         => __("address"),
                            'name'          => 'address',
                            'value'         => old("address",$user->address->address ?? ""),
                            'placeholder'   => __( "Write Here.."),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label><?php echo e(__("country")); ?><span>*</span></label>
                        <select name="country" class="form--control select2-auto-tokenize country-select" data-placeholder="<?php echo e(__('select Country')); ?>" data-old="<?php echo e(old('country',$user->address->country ?? "")); ?>"></select>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php
                            $old_state = old('state',$user->address->state ?? "");
                        ?>
                        <label><?php echo e(__("state")); ?></label>
                        <select name="state" class="form--control select2-auto-tokenize state-select" data-placeholder="Select State" data-old="<?php echo e($old_state); ?>">
                            <?php if($old_state): ?>
                                <option value="<?php echo e($old_state); ?>" selected><?php echo e($old_state); ?></option>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php
                            $old_city = old('city',$user->address->city ?? "");
                        ?>
                        <label><?php echo e(__("city")); ?></label>
                        <select name="city" class="form--control select2-auto-tokenize city-select" data-placeholder="Select City" data-old="<?php echo e($old_city); ?>">
                            <?php if($old_city): ?>
                                <option value="<?php echo e($old_city); ?>" selected><?php echo e($old_city); ?></option>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input',[
                            'label'         => __("Zip/Postal"),
                            'name'          => "zip_code",
                            'placeholder'   => __( "Write Here.."),
                            'value'         => old('zip_code',$user->address->zip ?? "")
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 form-group">
                        <?php echo $__env->make('admin.components.form.switcher', [
                            'label'         => __("Merchant Status"),
                            'value'         => old('status',$user->status),
                            'name'          => "status",
                            'options'       => [__("active") => 1, __("banned") => 0],
                            'permission'    => "admin.users.details.update",
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 form-group">
                        <?php echo $__env->make('admin.components.form.switcher', [
                            'label'         => __("email Verification"),
                            'value'         => old('email_verified',$user->email_verified),
                            'name'          => "email_verified",
                            'options'       => [ __("Verified") => 1, __("Unverified") => 0],
                            'permission'    => "admin.users.details.update",
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 form-group">
                        <?php echo $__env->make('admin.components.form.switcher', [
                            'label'     => __("2FA Verification"),
                            'value'     => old('two_factor_status',$user->two_factor_status),
                            'name'      => "two_factor_status",
                            'options'       => [ __("Verified") => 1, __("Unverified") => 0],
                            'permission'    => "admin.users.details.update",
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 form-group">
                        <?php echo $__env->make('admin.components.form.switcher', [
                            'label'     => __("KYC Verification"),
                            'value'     => old('kyc_verified',$user->kyc_verified),
                            'name'      => "kyc_verified",
                            'options'       => [ __("Verified") => 1, __("Unverified") => 0],
                            'permission'    => "admin.users.details.update",
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="col-xl-12 col-lg-12 form-group mt-4">
                        <?php echo $__env->make('admin.components.button.form-btn',[
                            'text'          => __("update"),
                            'permission'    => "admin.agents.details.update",
                            'class'         => "w-100 btn-loading",
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </form>
        </div>
    </div>

    
    <?php echo $__env->make('admin.components.modals.send-mail-merchant',compact("user"), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <?php if(admin_permission_by_name("admin.merchants.wallet.balance.update")): ?>
        <div id="wallet-balance-update-modal" class="mfp-hide large">
            <div class="modal-data">
                <div class="modal-header px-0">
                    <h5 class="modal-title"><?php echo e(__("Add/Subtract Balance")); ?></h5>
                </div>
                <div class="modal-form-data">
                    <form class="modal-form" method="POST" action="<?php echo e(setRoute('admin.merchants.wallet.balance.update',$user->username)); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row mb-10-none">
                            <div class="col-xl-12 col-lg-12 form-group">
                                <label for="balance"><?php echo e(__("type")); ?><span>*</span></label>
                                <select name="type" id="balance" class="form--control nice-select">
                                    <option disabled selected><?php echo e(__("Select Type")); ?></option>
                                    <option value="add"><?php echo e(__("Balance Add")); ?></option>
                                    <option value="subtract"><?php echo e(__("Balance Subtract")); ?></option>
                                </select>
                            </div>
                            <div class="col-xl-12 col-lg-12 form-group">
                                <label for="wallet"><?php echo e(__("User Wallet")); ?><span>*</span></label>
                                <select name="wallet" id="wallet" class="form--control select2-auto-tokenize">
                                    <option disabled selected><?php echo e(__("Select Merchants Wallet")); ?></option>
                                    <?php $__currentLoopData = $user->wallets()->get() ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($item->id); ?>"><?php echo e($item->currency->code); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-xl-12 col-lg-12 form-group">
                                <?php echo $__env->make('admin.components.form.input',[
                                    'label'         => __("Amount"),
                                    'label_after'   => "<span>*</span>",
                                    'type'          => 'text',
                                    'name'          => 'amount',
                                    'attribute'     => 'step="any"',
                                    'value'         => old("amount"),
                                     'placeholder'   =>  __("Write Here.."),
                                     'class'           =>  "number-input",
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="col-xl-12 col-lg-12 form-group">
                                <?php echo $__env->make('admin.components.form.input',[
                                    'label'         => __("Remark"),
                                    'label_after'   => "<span>*</span>",
                                    'name'          => "remark",
                                    'value'         => old("remark"),
                                     'placeholder'   =>  __("Write Here.."),
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="col-xl-12 col-lg-12 form-group d-flex align-items-center justify-content-between mt-4">
                                <button type="button" class="btn btn--danger modal-close"><?php echo e(__("close")); ?></button>
                                <button type="submit" class="btn btn--base"><?php echo e(__("action")); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        getAllCountries("<?php echo e(setRoute('global.countries')); ?>");
        $(document).ready(function() {

            openModalWhenError("email-send","#email-send");

            $("select[name=country]").change(function(){
                var phoneCode = $("select[name=country] :selected").attr("data-mobile-code");
                placePhoneCode(phoneCode);
            });

            setTimeout(() => {
                var phoneCodeOnload = $("select[name=country] :selected").attr("data-mobile-code");
                placePhoneCode(phoneCodeOnload);
            }, 400);

            countrySelect(".country-select",$(".country-select").siblings(".select2"));
            stateSelect(".state-select",$(".state-select").siblings(".select2"));


            $(".login-as-member").click(function() {
                var action  = "<?php echo e(setRoute('admin.merchants.login.as.member',$user->username)); ?>";
                var target  = "<?php echo e($user->username); ?>";
                postFormAndSubmit(action,target);
            });

        })

        $(".wallet-balance-update-btn").click(function(){
            // console.log($(this));
            openModalBySelector("#wallet-balance-update-modal");
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/admin/sections/merchant-care/details.blade.php ENDPATH**/ ?>