<?php
    $lang = selectedLang();
    $footer_slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::FOOTER_SECTION);
    $footer = App\Models\Admin\SiteSections::getData( $footer_slug)->first();
    $contact_slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::CONTACT_SECTION);
    $contact = App\Models\Admin\SiteSections::getData( $contact_slug)->first();
    $app_slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::APP_SECTION);
    $appInfo = App\Models\Admin\SiteSections::getData( $app_slug)->first();
    $type =  Illuminate\Support\Str::slug(App\Constants\GlobalConst::USEFUL_LINKS);
    $policies = App\Models\Admin\SetupPage::orderBy('id')->where('type', $type)->where('status',1)->get();
    $system_default    = $default_language_code;

?>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start footer
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<footer class="footer-section pt-60 bg_img" data-background="<?php echo e(get_image(@$footer->value->images->bg_image,'site-section')); ?>">
    <div class="container">
        <div class="footer-wrapper">
            <div class="row mb-30-none">
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 col-sm-6 mb-30">
                    <div class="footer-widget">
                        <div class="footer-logo">
                            <a class="site-logo site-title" href="<?php echo e(route('index')); ?>">
                                <img src="<?php echo e(get_logo($basic_settings)); ?>"  data-white_img="<?php echo e(get_logo($basic_settings,'white')); ?>"
                                data-dark_img="<?php echo e(get_logo($basic_settings,'dark')); ?>"
                                    alt="site-logo">
                            </a>
                        </div>
                        <div class="footer-content">
                            <p><?php echo e(__(@$footer->value->language->$lang->details)); ?></p>
                        </div>
                        <div class="footer-content-bottom">
                            <ul class="footer-list logo">
                                <li><a href="tel:<?php echo e(__(@$contact->value->language->$lang->mobile)); ?>"><i class="las la-phone-volume me-1"></i> +<?php echo e(__(@$contact->value->language->$lang->mobile)); ?></a></li>
                                <li><a href="mailto:<?php echo e(__(@$contact->value->language->$lang->email)); ?>"><i class="las la-envelope me-1"></i><?php echo e(__(@$contact->value->language->$lang->email)); ?></a></li>

                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-2 col-xl-2 col-lg-2 col-md-6 col-sm-6 mb-30">
                    <div class="footer-widget">
                        <h4 class="widget-title"><?php echo e(__("Useful LInks")); ?></h4>
                        <ul class="footer-list">
                            <?php $__currentLoopData = $policies ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a href="<?php echo e(setRoute('useful.link',$data->slug)); ?>"><?php echo e(@$data->title->language->$lang->title??@$data->title->language->$system_default->title); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <div class="col-xxl-2 col-xl-3 col-lg-2 col-md-6 col-sm-6 mb-30">
                    <div class="footer-widget">
                        <h4 class="widget-title"><?php echo e(__("Download App")); ?></h4>
                        <p><?php echo e(__(@$footer->value->language->$lang->app_text)); ?></p>
                        <ul class="footer-list two">
                            <li><a href="<?php echo e(@$appInfo->value->language->$lang->google_link); ?>"  target="_blank" class="app-img"><img src="<?php echo e(get_image(@$appInfo->value->images->google_play,'site-section')); ?>" alt="app"></a></li>
                            <li> <a href="<?php echo e(@$appInfo->value->language->$lang->apple_link); ?>"  target="_blank" class="app-img"><img src="<?php echo e(get_image(@$appInfo->value->images->appple_store,'site-section')); ?>" alt="app"></a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 col-sm-6 mb-30">
                    <div class="footer-widget">
                        <h4 class="widget-title"><?php echo e(__("Newsletter")); ?></h4>
                        <p><?php echo e(__(@$footer->value->language->$lang->newsltter_details)); ?></p>
                        <ul class="footer-list two">
                            <form action="<?php echo e(setRoute('newsletter.submit')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                            <li>
                                <input type="text" name="fullname" placeholder="<?php echo e(__("name")); ?>" class="form--control">
                                <span class="input-icon"><i class="las la-user"></i></span>
                                <?php $__errorArgs = ['fullname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </li>
                            <li>
                                <input type="email" name="email" placeholder="<?php echo e(__("enter Email Address")); ?>" class="form--control">
                                <span class="input-icon"><i class="las la-envelope"></i></span>
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </li>
                            <li>
                                <button type="submit" class="btn--base sub-btn btn-loading"><?php echo e(__("Subscribe")); ?><i class="las la-arrow-right ms-1"></i></button>
                            </li>
                           </form>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<div class="copyright-area mt-30 ptb-10">
    <div class="container">
        <div class="copyright-wrapper">
            <p><?php echo e(__(@$footer->value->language->$lang->footer_text)); ?> <a class="fw-bold" href="<?php echo e(setRoute('index')); ?>"> <?php echo e($basic_settings->site_name); ?></a></p>
            <ul class="footer-social">
                <?php if(isset($footer->value->items)): ?>
                    <?php $__currentLoopData = $footer->value->items ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><a href="<?php echo e(@$item->language->$lang->link); ?>" target="_blank"><i class="<?php echo e(@$item->language->$lang->social_icon); ?>"></i></a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</div>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End footer
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<?php /**PATH E:\xampp-8.0.2\htdocs\simple-pay\resources\views/frontend/partials/footer.blade.php ENDPATH**/ ?>