<table class="custom-table bank-search-table">
    <thead>
        <tr>
            <th></th>
            <th><?php echo e(__("bank Name")); ?></th>
            <th><?php echo e(__("Currency Code")); ?></th>
            <th><?php echo e(__("Currency Symbol")); ?></th>
            <th><?php echo e(__("Created Time")); ?></th>
            <th><?php echo e(__("Status")); ?></th>
            <th><?php echo e(__("action")); ?></th>
        </tr>
    </thead>
    <tbody>

        <?php $__empty_1 = true; $__currentLoopData = $banks ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr data-item="<?php echo e($item->editData); ?>">
                <td>
                    <ul class="user-list">
                        <li><img src="<?php echo e(get_image($item->image,'bank-images')); ?>" alt="Image"></li>
                    </ul>
                </td>
                <td><?php echo e($item->name); ?></td>
                <td><?php echo e($item->code); ?></td>
                <td><?php echo e($item->currency_symbol); ?></td>
                <td><?php echo e($item->created_at->format('d-m-y h:i:s A')); ?></td>

                <td>
                    <?php echo $__env->make('admin.components.form.switcher',[
                        'name'          => 'bank_status',
                        'value'         => $item->status,
                        'options'       => [__("Enable") => 1,__("Disable") => 0],
                        'onload'        => true,
                        'data_target'   => $item->id,
                        'permission'    => "admin.remitance.bank.deposit.status.update",
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </td>

                <td>
                    <?php echo $__env->make('admin.components.link.edit-default',[
                        'href'          => setRoute('admin.remitance.bank.deposit.edit',$item->id),
                        'class'         => "",
                        'permission'    => "admin.remitance.bank.deposit.update",
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php echo $__env->make('admin.components.link.delete-default',[
                        'href'          => "javascript:void(0)",
                        'class'         => "delete-modal-button",
                        'permission'    => "admin.remitance.bank.deposit.delete",
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <?php echo $__env->make('admin.components.alerts.empty',['colspan' => 7], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
    </tbody>
</table>

<?php $__env->startPush("script"); ?>
    <script>
        $(document).ready(function(){
            // Switcher
            switcherAjax("<?php echo e(setRoute('admin.remitance.bank.deposit.status.update')); ?>");
        })
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH E:\xampp-8.0.2\htdocs\simple-pay\resources\views/admin/components/data-table/bank-deposit-table.blade.php ENDPATH**/ ?>