@extends('admin.layouts.master')

@push('css')

@endpush

@section('page-title')
    @include('admin.components.page-title',['title' => __($page_title)])
@endsection

@section('breadcrumb')
    @include('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ]
    ], 'active' => __("User Account Data")])
@endsection

@section('content')
<div class="table-area">
    <div class="table-wrapper">
        <div class="table-header">
            <h5 class="title">{{ $page_title }}</h5>
            @if(count($transactions) > 0)
            <div class="table-btn-area">
                <a href="{{ setRoute('admin.remitance.export.data') }}" class="btn--base"><i class="fas fa-download me-1"></i>{{ __("Export Data") }}</a>
            </div>
        @endif
        </div>
        <div class="table-responsive">
            <table class="custom-table">
                <thead>
                    <tr>
                        <th>{{ __("web_trx_id") }}</th>
                        <th>{{ __("User ") }}</th>
                        <th>{{ __("Receiver") }}</th>
                        <th>{{ __("Account Type") }}</th>
                        <th>{{ __(("Details")) }}</th>
                        <th>{{ __(("Status")) }}</th>
                        <th>{{ __("Time") }}</th>
                        <th>{{__("action")}}</th>
                    </tr>
                </thead>
				@php 
				//dd(Auth::user());
				@endphp 
                <tbody>
                    @forelse ($transactions  as $key => $item)

                        <tr>
                            <td>{{ $item->accountId }}</td>
                            <td>{{$item->firstname}} {{$item->lastname}}
                                
                                    <a href="setRoute('admin.users.details',$item->username)">{{ $item->username }}</a>

                            </td>
                            <td>
							{{$item->currencyName}}

                            </td>
                            <td >
								@php
									$arr=(array)json_decode($item->accountDATA,true);
									//$arr['Account Type']
								@endphp
								<span class="fw-bold"> {{@$arr['Account Type']}} {{__("Account")}} </span>								

                            </td>
                            {{-- <td ><span class="fw-bold">{{ @$item->details->bill_number }}</span></td> --}}
                            <td> <a id="detail" data-id="{{ $item->accountId }}" href="#">
				@if(Auth::user()->id==2)		
							{!! $item->details; !!}</a> 
				@endif
							
							
							
							</td>
                            <td>
                                <span class="">@php 
								
        if($item->accountStatus == 1) {
            $data = [
                'class'     => "badge badge--success",
                'value'     => "Verified",
            ];
        }else if($item->accountStatus == 0) {
            $data = [
                'class'     => "badge badge--warning",
                'value'     => "Pending",
            ];
        }else if($item->accountStatus == 2) {
            $data = [
                'class'     => "badge badge--danger",
                'value'     => "Rejected",
            ];
        }else {
            $data = [
                'class'     => "badge badge--danger",
                'value'     => "Unverified",
            ];
        }


//								if($item->accountStatus==0)echo __("Pending"//);elseif($item->accountStatus==1) echo __("Approve"); 
								@endphp</span>
							<span class="{{ $data['class'] }}">{{ __($data['value']) }}</span>								
                            </td>
                            <td>{{ $item->created_at }}</td>
                            <td>
								<div class="button--group">
										@if (request()->routeIs('admin.merchantbankaccount.pending'))  
											<a href="{{ route('admin.merchantbankaccount.details', $item->accountId) }}" target="_blank" class="btn--base btn-sm btn-outline--dark">
												<i class="las la-user-check"></i>@lang('Account Details')
											</a>
										@endif
										@if (request()->routeIs('admin.merchantbankaccount.complete'))  
											<a href="{{ route('admin.merchantbankaccount.update', $item->accountId) }}" target="_blank" class="btn--base btn-sm btn-outline--dark">
												<i class="las la-user-check"></i>@lang('Account Details')
											</a>
										@endif										
										
									
									</div>
                            </td>
                        </tr>
                    @empty
                         @include('admin.components.alerts.empty',['colspan' => 8])
                    @endforelse
                </tbody>
            </table>
        </div>
        {{ get_paginate($transactions) }}
    </div>
</div>
@endsection

@push('script')

@endpush
