<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('group_has_transaction_charges', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('admin_id')->nullable();
            $table->unsignedBigInteger('group_id');
            $table->string('slug',50);
            $table->string('title',100)->nullable();
            $table->decimal('fixed_charge',8,2,true)->default(0);
            $table->decimal('percent_charge',8,2,true)->default(0);
            $table->decimal('min_limit',8,2,true)->default(0);
            $table->decimal('max_limit',8,2,true)->default(0);
            $table->decimal('monthly_limit',8,2,true)->default(0);
            $table->decimal('daily_limit',8,2,true)->default(0);
            $table->decimal('agent_fixed_commissions',8,2,true)->default(0);
            $table->decimal('agent_percent_commissions',8,2,true)->default(0);
            $table->boolean('agent_profit')->default(false);
            $table->boolean('status')->default(1);
            $table->timestamps();

            $table->foreign('admin_id')->references('id')->on('admins')->onUpdate('cascade');
            $table->foreign('group_id')->references('id')->on('setup_user_groups')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('group_has_transaction_charges');
    }
};
