
<?php
    $lang = selectedLang();
    $overview_slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::OVERVIEW_SECTION);
    $overview = App\Models\Admin\SiteSections::getData( $overview_slug)->first();
    $currencies = App\Models\Admin\currency::count();
    $payment_gateways = App\Models\Admin\PaymentGateway::where('slug','add-money')->count();
    $send_remittamce = App\Models\Transaction::where('type','REMITTANCE')->where('attribute','SEND')->count();
?>
<div class="map-section pt-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-7 text-center">
                <div class="section-header">
                    <span class="section-sub-titel"><i class="fas fa-qrcode"></i> <?php echo e(__(@$overview->value->language->$lang->title)); ?></span>
                    <h2 class="section-title"><?php echo e(__(@$overview->value->language->$lang->heading)); ?></h2>
                    <p><?php echo e(__(@$overview->value->language->$lang->sub_heading)); ?></p>
                </div>
            </div>
        </div>
        <div class="map-wrapper">
            <div class="thumb">
                <img src="<?php echo e(get_image(@$overview->value->images->map_image,'site-section')); ?>" alt="map">
            </div>
        </div>
        <div class="map-content">
            <div class="map-statistics-wrapper">
                <div class="statistics-item">
                    <div class="statistics-content">
                        <div class="odo-area">
                            <h3 class="odo-title odometer" data-odometer-final="<?php echo e(@$payment_gateways); ?>">0</h3>
                            <h3 class="title">+</h3>
                        </div>
                        <p><?php echo e(__("Payment Gateway")); ?></p>
                    </div>
                </div>
                <div class="statistics-item">
                    <div class="statistics-content">
                        <div class="odo-area">
                            <h3 class="odo-title odometer" data-odometer-final="<?php echo e(__( @$currencies)); ?>">0</h3>
                            <h3 class="title">+</h3>
                        </div>
                        <p><?php echo e(__("Currencies")); ?></p>
                    </div>
                </div>
                <div class="statistics-item">
                    <div class="statistics-content">
                        <div class="odo-area">
                            <h3 class="odo-title odometer" data-odometer-final="<?php echo e(@$send_remittamce); ?>">0</h3>
                            <h3 class="title">+</h3>
                        </div>
                        <p><?php echo e(__("Send Remittance")); ?></p>
                    </div>
                </div>
            </div>
            <div class="content-bottom">
                <p> <?php echo e(__(@$overview->value->language->$lang->botton_text)); ?></p>
                <a href="<?php echo e(url('/').'/'. @$overview->value->language->$lang->button_link); ?>"> <?php echo e(__(@$overview->value->language->$lang->button_name)); ?> <i class="las la-arrow-right"></i></a>
            </div>
        </div>
    </div>
</div>
<?php /**PATH E:\xampp-8.0.2\htdocs\simple-pay\resources\views/frontend/partials/map-section.blade.php ENDPATH**/ ?>