@extends('admin.layouts.master')

@push('css')

@endpush

@section('page-title')
    @include('admin.components.page-title',['title' => __($page_title)])
@endsection

@section('breadcrumb')
    @include('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ]
    ], 'active' => __($page_title)])
@endsection

@section('content')
<form class="card-form" method="POST" action="{{ setRoute('admin.setup.group.agents.store') }}">
    @csrf
    <div class="custom-card mb-10">
        <div class="card-header">
            <h6 class="title">{{ __("Basic Informations") }}</h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-xl-6 col-lg-6 mb-10">
                    <div class="custom-inner-card">
                        <div class="card-inner-header">
                            <h5 class="title">{{ __("Group Name") }}</h5>
                        </div>
                        <div class="card-inner-body">
                            <div class="row">
                                <div class="col-xl-12 col-lg-12 form-group">
                                    <input type="text" placeholder={{ __('Enter Group Name') }} name="group_name" class="form--control  " value="{{ old('group_name') }}">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6 mb-10">
                    <div class="custom-inner-card">
                        <div class="card-inner-header">
                            <h5 class="title">{{ __("Assign Agents") }}</h5>
                        </div>
                        <div class="card-inner-body">
                            <div class="row">
                                <div class="col-xl-12 col-lg-12 form-group">
                                    <select name="agents[]" multiple id="" class=" form--control select2-auto-tokenize" data-placeholder="{{ __("Select Agents") }}">
                                        @foreach ($allAgents ?? [] as $agent)

                                            @if(in_array($agent->id,$assignedGroupAgents))
                                            @else
                                            <option value="{{ $agent->id }}">{{ ucwords($agent->fullname) }}</option>
                                            @endif

                                        @endforeach

                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @foreach ($transaction_charges as $item)
        @include('admin.components.charge-group.user-trx-settings-charge-block',[
            'title'         => $item->title,
            'data'          => $item,
        ])
    @endforeach
    <div class="row mb-10-none">
        <div class="col-xl-12 col-lg-12 form-group">
            @include('admin.components.button.form-btn',[
                'text'          => __("Create Group"),
                'class'         => "w-100 btn-loading",
                'permission'    => "admin.setup.group.agents.create",
            ])
        </div>
    </div>
</form>
@endsection

@push('script')

@endpush
