


<?php
    $lang = selectedLang();
    $auth_slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::AUTH_SECTION);
    $auth_text = App\Models\Admin\SiteSections::getData( $auth_slug)->first();
?>


<?php $__env->startSection('content'); ?>

<section class="account">

    <div class="account-area">
        <div class="account-wrapper">
            <div class="account-logo text-center">
               <a class="site-logo" href="<?php echo e(setRoute('index')); ?>">
                <img src="<?php echo e(get_logo($basic_settings)); ?>"  data-white_img="<?php echo e(get_logo($basic_settings,'white')); ?>"
                data-dark_img="<?php echo e(get_logo($basic_settings,'dark')); ?>"
                    alt="site-logo">
               </a>
            </div>
            <h5 class="title"><?php echo e(__("Reset Your Forgotten Password")); ?></h5>
            <p><?php echo e(__(@$auth_text->value->language->$lang->forget_text)); ?></p>
            <form class="account-form" action="<?php echo e(setRoute('user.password.forgot.send.code')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="row ml-b-20">

                    <div class="col-xl-12 col-lg-12 form-group">
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text copytext"><span><?php echo e(__("Email")); ?></span></span>
                            </div>
                            <input type="email" name="credentials" class="form--control checkUser mobile" placeholder="<?php echo e(__('enter Email Address')); ?>">

                        </div>
                        <small class="text-danger exits"></small>
                    </div>

                    <div class="col-lg-12 form-group text-center">
                        <button type="submit"  class="btn--base w-100 btn-loading"><?php echo e(__("Continue")); ?></button>
                    </div>
                    <div class="col-lg-12 text-center">
                        <div class="account-item">
                            <label><?php echo e(__("already Have An Account")); ?> <a href="<?php echo e(setRoute('user.login')); ?>" class="account-control-btn"><?php echo e(__("Login Now")); ?></a></label>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End acount
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->

<ul class="bg-bubbles">
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
</ul>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.user_auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp 8.0.2\htdocs\simple-pay\resources\views/user/auth/forgot-password/forgot.blade.php ENDPATH**/ ?>