

<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('agent.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("agent.dashboard"),
        ]
    ], 'active' => __(@$page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="body-wrapper">
    <div class="dashboard-area mt-10">
        <div class="dashboard-header-wrapper">
            <h3><?php echo e(__($page_title)); ?></h3>
            <a href="<?php echo e(setRoute('agent.sender.recipient.add')); ?>" class="btn--base"><?php echo e(__("Add")); ?> <i class="fas fa-plus-circle ms-2"></i></a>
        </div>
    </div>
    <div class="dashboard-list-area mt-20">
        <div class="dashboard-list-wrapper">
            <?php $__empty_1 = true; $__currentLoopData = $recipients ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="dashboard-list-item-wrapper">
                <div class="dashboard-list-item sent">
                    <div class="dashboard-list-left">
                        <div class="dashboard-list-user-wrapper">
                            <div class="dashboard-list-user-icon">
                                <i class="las la-arrow-up"></i>
                            </div>
                            <div class="dashboard-list-user-content">

                                <h4 class="title"><?php echo e(@$data->fullname); ?>

                                    <?php if($data->type == "wallet-to-wallet-transfer"): ?>
                                        <span class="text-success">( <?php echo e(@$basic_settings->site_name); ?> <?php echo e(__("rWallet")); ?> )</span>
                                    <?php elseif($data->type == "cash-pickup"): ?>
                                        <span class="text-success">( <?php echo e(__("r".@$data->type)); ?> )</span>
                                    <?php else: ?>
                                        <span class="text-success">( <?php echo e(__(@$data->type)); ?> )</span>
                                    <?php endif; ?> </h4>
                                <span class="sub-title text--warning"><?php echo e(@$data->email); ?></span>

                            </div>
                        </div>
                    </div>
                    <div class="dashboard-list-right">
                        <div class="dashboard-list-right-btn-area">
                            <a href="<?php echo e(setRoute('agent.sender.recipient.send.remittance',$data->id)); ?>" class="btn--base"><i class="fas fa-paper-plane"></i></a>
                            <a href="<?php echo e(setRoute('agent.sender.recipient.edit',$data->id)); ?>" class="btn--base"><i class="fas fa-edit"></i></a>
                            <button type="button" class="btn--base delete-btn " data-id="<?php echo e($data->id); ?>" data-name="<?php echo e($data->fullname); ?>"><i class="fas fa-trash"></i></button>
                        </div>
                    </div>
                </div>

            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="alert alert-primary text-center">
                <?php echo e(__("No Sender Recipient Found!")); ?>

            </div>
            <?php endif; ?>

        </div>
    </div>
    <nav>
        <ul class="pagination">
            <?php echo e(get_paginate($recipients)); ?>

        </ul>
    </nav>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
     $(".delete-btn").click(function(){
            var actionRoute =  "<?php echo e(setRoute('agent.sender.recipient.delete')); ?>";
            var target      = $(this).data('id');
            var btnText = "Delete";
            var name = $(this).data('name');
            var message     = `Are you sure to delete <strong>${name}</strong>?`;
            openAlertModal(actionRoute,target,message,btnText,"DELETE");
        });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('agent.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp-8.0.2\htdocs\simple-pay\resources\views/agent/sections/sender_recipient/index.blade.php ENDPATH**/ ?>