<table class="custom-table group-search-table">
    <thead>
        <tr>

            <th>{{ __("Group Name") }}</th>
            <th></th>
            <th>{{ __("Created Time") }}</th>
            <th></th>
            <th>{{ __("Status") }}</th>
            <th></th>
            <th>{{ __("Action") }}</th>
        </tr>
    </thead>
    <tbody>

        @forelse ($allGroups ?? [] as $item)
            <tr data-item="{{ $item->editData }}">
                <td>{{ $item->name }}</td>
                <td></td>
                <td>{{ $item->created_at->format('d-m-y h:i:s A') }}</td>
                <td></td>

                <td>
                    @if(@$item->delete_able == true)
                    @include('admin.components.form.switcher',[
                        'name'          => 'group_status',
                        'value'         => $item->status,
                        'options'       => ['Enable' => 1,'Disable' => 0],
                        'onload'        => true,
                        'data_target'   => $item->id,
                        'permission'    => "admin.setup.group.status.update",
                    ])
                    @else
                    <span class="text-warning">{{ __("Status Can't Changeable") }} <br>{{__("For Default Group")}}</span>
                    @endif
                </td>
                <td></td>

                <td>
                    @include('admin.components.link.edit-default',[
                        'href'          => setRoute('admin.setup.group.agents.edit',$item->id),
                        'class'         => "edit-modal-button",
                        'permission'    => "admin.currency.update",
                    ])
                    @if(@$item->delete_able == true)
                    @include('admin.components.link.delete-default',[
                        'href'          => "javascript:void(0)",
                        'class'         => "delete-modal-button",
                        'permission'    => "admin.setup.group.agents.delete",
                    ])
                    @endif



                </td>
            </tr>
        @empty
            @include('admin.components.alerts.empty',['colspan' => 7])
        @endforelse
    </tbody>
</table>

@push("script")
    <script>
        $(document).ready(function(){
            // Switcher
            switcherAjax("{{ setRoute('admin.setup.group.agents.status.update') }}");
        })
    </script>
@endpush
