
<div class="custom-card mb-10">
    <div class="card-header">
        <h6 class="title">{{ $title ?? "" }}</h6>
    </div>
    <div class="card-body">
        <input type="hidden" value="{{ $data->slug }}" name="slug">
        <input type="hidden" value="{{ $data->agent_profit == false ? 0 : 1 }}" name="{{$data->slug}}_agent_profit">
        <div class="row">
            <div class="{{ $item->agent_profit == true ? 'col-xl-4 col-lg-4': 'col-xl-6 col-lg-6 '}} mb-10">
                <div class="custom-inner-card">
                    <div class="card-inner-header">
                        <h5 class="title">{{ __("Charges") }}</h5>
                    </div>
                    <div class="card-inner-body">
                        <div class="row">
                            <div class="col-xxl-12 col-xl-6 col-lg-6 form-group">
                                <label>{{ __("Fixed Charge*") }}</label>
                                <div class="input-group">
                                    <input type="text" placeholder="0.00" class="form--control number-input" value="{{ old($data->slug.'_fixed_charge') }}" name="{{$data->slug}}_fixed_charge">
                                    <span class="input-group-text">{{ get_default_currency_code($default_currency) }}</span>
                                </div>
                            </div>
                            <div class="col-xxl-12 col-xl-6 col-lg-6 form-group">
                                <label>{{ __("Percent Charge*") }}</label>
                                <div class="input-group">
                                    <input type="text" placeholder="0.00" class="form--control number-input" value="{{ old($data->slug.'_percent_charge') }}" name="{{$data->slug}}_percent_charge">
                                    <span class="input-group-text">%</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="{{ $item->agent_profit == true ? 'col-xl-4 col-lg-4': 'col-xl-6 col-lg-6 '}} mb-10">
                <div class="custom-inner-card">
                    <div class="card-inner-header">
                        <h5 class="title">{{ __("Range") }}</h5>
                    </div>
                    <div class="card-inner-body">
                        <div class="row">
                            <div class="col-xxl-12 col-xl-6 col-lg-6  form-group">
                                <label>{{ __("Minimum amount") }}</label>
                                <div class="input-group">
                                    <input type="text" class="form--control number-input" placeholder="0.00" value="{{ old($data->slug.'_min_limit') }}" name="{{$data->slug}}_min_limit">
                                    <span class="input-group-text">{{ get_default_currency_code($default_currency) }}</span>
                                </div>
                            </div>
                            <div class="col-xxl-12 col-xl-6 col-lg-6 form-group">
                                <label>{{ __("Maximum amount") }}</label>
                                <div class="input-group">
                                    <input type="text" class="form--control number-input" placeholder="0.00" value="{{ old($data->slug.'_max_limit') }}" name="{{$data->slug}}_max_limit">
                                    <span class="input-group-text">{{ get_default_currency_code($default_currency) }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @if( $item->agent_profit == true)
                <div class="col-xl-4 col-lg-4 mb-10">
                    <div class="custom-inner-card">
                        <div class="card-inner-header">
                            <h5 class="title-agent">{{ __("Agent Profits") }}</h5>
                        </div>
                        <div class="card-inner-body">
                            <div class="row">
                                <div class="col-xxl-12 col-xl-6 col-lg-6 form-group">
                                    <label>{{ __("Fixed Commissions") }}</label>
                                    <div class="input-group">
                                        <input type="text" placeholder="0.00" class="form--control number-input" value="{{ old($data->slug.'_agent_fixed_commissions') }}" name="{{$data->slug}}_agent_fixed_commissions">
                                        <span class="input-group-text">{{ get_default_currency_code($default_currency) }}</span>
                                    </div>
                                </div>
                                <div class="col-xxl-12 col-xl-6 col-lg-6 form-group">
                                    <label>{{ __("Percent Commissions") }}</label>
                                    <div class="input-group">
                                        <input type="text" placeholder="0.00" class="form--control number-input" value="{{ old($data->slug.'_agent_percent_commissions') }}" name="{{$data->slug}}_agent_percent_commissions">
                                        <span class="input-group-text">{{ get_default_currency_code($default_currency) }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @else
            <input type="hidden" class="form--control number-input" value="{{ old($data->slug.'_agent_fixed_commissions',0) }}" name="{{$data->slug}}_agent_fixed_commissions">
            <input type="hidden" class="form--control number-input" value="{{ old($data->slug.'_agent_percent_commissions',0) }}" name="{{$data->slug}}_agent_percent_commissions">

            @endif
        </div>
    </div>
</div>
