<?php

namespace App\Http\Controllers\Merchant;


use App\Http\Controllers\Controller;
use App\Http\Helpers\PushNotificationHelper;
use App\Models\Admin\SetupKyc;
use App\Providers\Admin\BasicSettingsProvider;
use App\Models\Merchants\MerchantWallet;
use App\Models\Merchants\SandboxWallet;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules\Password;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;
use App\Traits\AdminNotifications\AuthNotifications;





//use App\Models\Receipient;
//use Illuminate\Support\Str;
//use Illuminate\Http\Request;
//use Request;
use App\Constants\GlobalConst;
//use App\Constants\NotificationConst;
//use App\Constants\PaymentGatewayConst;
//use App\Http\Controllers\Controller;
//use App\Http\Helpers\NotificationHelper;
//use App\Http\Helpers\PushNotificationHelper;
use App\Models\Admin\BasicSettings;
use App\Models\Admin\Currency;
use App\Models\Merchant;
//use App\Models\Transaction;
//use App\Models\UserNotification;
//use App\Models\UserWallet;
use App\Notifications\User\Remittance\BankTransferMail;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use App\Http\Helpers\Response;
//use App\Models\RemitanceBankDeposit;
//use App\Notifications\Admin\ActivityNotification;
//use Illuminate\Support\Facades\Validator;
//use Stripe\Charge;
//use Illuminate\Support\Facades\Storage;

class BankAccountController extends Controller
{
    protected  $trx_id;
    public function __construct()
    {
        $this->trx_id = 'RT'.getTrxNum();
    }
    public function index() {
        $page_title =__( "Bank Account");
		$user = auth()->user();
		//dd($user);
		//$user = userGuard()['user'];
        //$exchangeCharge = userGroupTransactionsCharges(GlobalConst::REMITTANCE);
        //$senderCountries = Currency::sender()->active()->get();
        //$receiverCountries = Currency::receiver()->active()->orderBy('id',"DESC")->get();
        //$receipients = Receipient::auth()->orderByDesc("id")->paginate(12);
        //$transactions = Transaction::auth()->remitance()->latest()->take(5)->get();
		$user_accounts = DB::table('merchant_accounts')->where('merchant_id', $user->id)->orderBy('created_at', 'desc')->get();
		
		
/*         $fiat_wallets = UserWallet::auth()->whereHas("currency",function($q) {
            return $q->where("type",GlobalConst::FIAT);
        })->limit(8)->get();

        $crypto_wallets = UserWallet::auth()->whereHas("currency",function($q) {
            return $q->where("type",GlobalConst::CRYPTO);
        })->limit(8)->get(); */
		
        $fiat_wallets   = MerchantWallet::auth()->whereHas("currency",function($q) {
            return $q->where("type",GlobalConst::FIAT);
        })->limit(8)->get();

        $crypto_wallets = MerchantWallet::auth()->whereHas("currency",function($q) {
            return $q->where("type",GlobalConst::CRYPTO);
        })->limit(8)->get();		
		
		
		
		
		
		
        return view('merchant.sections.account.index',compact(
            "page_title",
//            'exchangeCharge',
//            'senderCountries',
//            'receiverCountries',
//            'receipients',
//            'transactions',
			'fiat_wallets',
			'crypto_wallets',
			'user_accounts'
        ));
    }
	
	public function getOpenAccount(Request  $request){
	
		$user = auth()->user();	
		$type=$request->acc_type;
	 	$id = DB::table('currencies')->where('code', $request->currency_name)->value('id');
			
		if ($request->acc_type=='personal'){

    $request->validate( [
		'file1' => 'required|mimes:jpg,png,pdf|max:12048',
		'file2' => 'required|mimes:jpg,png,pdf|max:12048',
		'file3' => 'required|mimes:jpg,png,pdf|max:12048'
    ],[
    'file1.required'=> 'ID/Passport File is Required', // custom message
	'file1.mimes'=> 'ID/Passport File type is :values', // custom message
	'file2.required'=> 'Bank Statement File is Required', // custom message	
    'file2.mimes'=> 'Bank Statement File type is :values', // custom message
    'file3.required'=> 'Selfie with ID/Passport File is Required', // custom message
	'file3.mimes'=> 'Selfie with ID/Passport File type is :values' // custom message
   ]);			
			
			$destinationPath = 'users/bankaccount/uploads';			

			
			$response['Code'] = $request->currency_name;
			$response['Currency Id'] = $id;
			$response['Account Type'] = $type;
			//$response['CNIC'] = $request->cardno;
			
			if($request->hasFile('file1'))
			{
				$file1 = $request->file('file1');
//echo env('APP_URL').'/storage/app/public/';//storage_path('app');//public_path('storage');				
				$path = $file1->store($destinationPath , 'public');			
			//	echo Storage::url($path);
				
				$response['ID/Passport File']=[
					'filename' => $file1->getClientOriginalName(),
					'File Extension' => $file1->getClientOriginalExtension(),
					'File Size' => $file1->getSize(),
					'File Mime Type' => $file1->getMimeType(),
					'path'=>'/storage/app/public/'.$path
				];			
				
			}
			if($request->hasFile('file2'))
			{
				$file2 = $request->file('file2');
				$path = $file2->store($destinationPath , 'public');			
				$response['Bank Statement File']=[
					'filename' => $file2->getClientOriginalName(),
					'File Extension' => $file2->getClientOriginalExtension(),
					'File Size' => $file2->getSize(),
					'File Mime Type' => $file2->getMimeType(),
					'path'=>'/storage/app/public/'.$path
				];			
				
			}
			if($request->hasFile('file3'))
			{
				$file3 = $request->file('file3');
				$path = $file3->store($destinationPath , 'public');			
				$response['Selfie with ID/Passport File']=[
					'filename' => $file3->getClientOriginalName(),
					'File Extension' => $file3->getClientOriginalExtension(),
					'File Size' => $file3->getSize(),
					'File Mime Type' => $file3->getMimeType(),
					'path'=>'/storage/app/public/'.$path
				];			      
				
			}


		}else{


 
    $request->validate([
		'comp_name' => 'required',
		'comp_website' => 'required',
		'comp_reg_country' => 'required',
		'comp_add' => 'required',

        'file4' => 'required|mimes:jpg,png,pdf|max:12048',
		'file5' => 'required|mimes:jpg,png,pdf|max:12048',
		'file6' => 'required|mimes:jpg,png,pdf|max:12048',
        'file7' => 'required|mimes:jpg,png,pdf|max:12048',
		'file8' => 'required|mimes:jpg,png,pdf|max:12048',
		'file9' => 'required|mimes:jpg,png,pdf|max:12048'
		
    ],[
    'comp_name.required'=> 'Business Name is Required', // custom message
    'comp_website.required'=> 'Business Website is Required', // custom message
    'comp_reg_country.required'=> 'Country of Registration is Required', // custom message
    'comp_add.required'=> 'Business Address is Required', // custom message	
    'file4.required'=> 'UBO and Directors Passports File is Required', // custom message
	'file4.mimes'=> 'UBO and Directors Passports File type is :values', // custom message
	'file5.required'=> 'Company Bank Statement File is Required', // custom message	
    'file5.mimes'=> 'Company Bank Statement File type is :values', // custom message
    'file6.required'=> 'Memorandum of Articles File is Required', // custom message
	'file6.mimes'=> 'Memorandum of Articles File type is :values', // custom message
    'file7.required'=> 'Company Certificate File is Required', // custom message
	'file7.mimes'=> 'Company Certificate File type is :values', // custom message
	'file8.required'=> 'UBO Proof of Address File is Required', // custom message	
    'file8.mimes'=> 'UBO Proof of Address File type is :values', // custom message
    'file9.required'=> 'Company Letter Head File is Required', // custom message
	'file9.mimes'=> 'Company Letter Head File type is :values' // custom message


   ]);	 


			$destinationPath = 'users/bankaccount/uploads';			

			
			$response['Code'] = $request->currency_name;
			$response['Currency Id'] = $id;
			$response['Account Type'] = $type;
			$response['Company Name'] = $request->comp_name;
			
			if($request->hasFile('file4'))
			{
				$file4 = $request->file('file4');
				$path = $file4->store($destinationPath , 'public');			
				$response['UBO and Directors Passports File']=[
					'filename' => $file4->getClientOriginalName(),
					'File Extension' => $file4->getClientOriginalExtension(),
					'File Size' => $file4->getSize(),
					'File Mime Type' => $file4->getMimeType(),
					'path'=>'/storage/app/public/'.$path
				];			
				
			}
			if($request->hasFile('file5'))
			{
				$file5 = $request->file('file5');
				$path = $file5->store($destinationPath , 'public');			
				$response['Company Bank Statement File']=[
					'filename' => $file5->getClientOriginalName(),
					'File Extension' => $file5->getClientOriginalExtension(),
					'File Size' => $file5->getSize(),
					'File Mime Type' => $file5->getMimeType(),
					'path'=>'/storage/app/public/'.$path
				];			
				
			}
			if($request->hasFile('file6'))
			{
				$file6 = $request->file('file6');
				$path = $file6->store($destinationPath , 'public');			
				$response['Memorandum of Articles File']=[
					'filename' => $file6->getClientOriginalName(),
					'File Extension' => $file6->getClientOriginalExtension(),
					'File Size' => $file6->getSize(),
					'File Mime Type' => $file6->getMimeType(),
					'path'=>'/storage/app/public/'.$path
				];			      
				
			}
			if($request->hasFile('file7'))
			{
				$file7 = $request->file('file7');
				$path = $file7->store($destinationPath , 'public');			
				$response['Company Certificate File']=[
					'filename' => $file7->getClientOriginalName(),
					'File Extension' => $file7->getClientOriginalExtension(),
					'File Size' => $file7->getSize(),
					'File Mime Type' => $file7->getMimeType(),
					'path'=>'/storage/app/public/'.$path
				];			      
				
			}
			if($request->hasFile('file8'))
			{
				$file8 = $request->file('file8');
				$path = $file8->store($destinationPath , 'public');			
				$response['UBO Proof of Address File']=[
					'filename' => $file8->getClientOriginalName(),
					'File Extension' => $file8->getClientOriginalExtension(),
					'File Size' => $file8->getSize(),
					'File Mime Type' => $file8->getMimeType(),
					'path'=>'/storage/app/public/'.$path
				];			      
				
			}
			if($request->hasFile('file9'))
			{
				$file9 = $request->file('file9');
				$path = $file9->store($destinationPath , 'public');			
				$response['Company Letter Head File']=[
					'filename' => $file9->getClientOriginalName(),
					'File Extension' => $file9->getClientOriginalExtension(),
					'File Size' => $file9->getSize(),
					'File Mime Type' => $file9->getMimeType(),
					'path'=>'/storage/app/public/'.$path
				];			      
				
			}			
			
			
		}
		
		
		

		

$response['Time']= time();		

		

//$response = ['success' => true];

		
		$arr=[
                "merchant_id"=>$user->id,
                "currency_id"=>$id,
                "balance"=>0,
				"data"=>json_encode($response),
				"details"=>"",
                "status"=>0,
				"created_at"=>date('Y-m-d H:i:s')
            ];
									
		$order_id = DB::table('merchant_accounts')->insertGetId($arr);
//DB::commit();
//return response()->json(['success'=>'Added new records.']);
//}


//$object = (array)json_decode($tt);
//$collection = \App\User::hydrate($object);
//$collection = $collection->flatten();   // get rid of unique_id_XXX

/*
    Collection {#236 ▼
      #items: array:2 [▼
        0 => User {#239 ▶}
        1 => User {#240 ▶}
      ]
    }
 */
//dd($object);

$response = [
            'success' => true,
            'insertted' => $order_id,
			'code' => $request->currency_name,
			'Currency Code' => $id,
			'Time'=> time()
        ];
		return response()->json($response);		
		
		
		
		
		
		
		
		return response()->json(['success'=>'Added new records.']);
	}
	

    public function confirmed(Request $request){
        $validator = Validator::make($request->all(),[
            'form_country'               =>'required',
            'to_country'                 =>'required',
            'transaction_type'           =>'required|string',
            'recipient'                  =>'required',
            'send_amount'                =>"required|numeric",
            'receive_amount'             =>'required|numeric',
        ]);
        if($validator->fails()) {
            return Response::error($validator->errors());
        }

        $validated = $validator->validate();
        $transaction_type = $request->transaction_type;
        $basic_setting = BasicSettings::first();
        $user = userGuard()['user'];

        $recipient = Receipient::with('receiver_bank')->auth()->where("id",$request->recipient)->first();
        if(!$recipient) return Response::error([__('Recipient is invalid')]);

        $sender_currency = Currency::where('id',$request->form_country)->active()->first();
        if(!$sender_currency) return Response::error([__('Sender Country Not Found')]);

        $exchangeCharge = get_remittance_charges($transaction_type,userGroupTransactionsCharges(GlobalConst::REMITTANCE),$recipient,$sender_currency);
        $userWallet = UserWallet::where('user_id',$user->id)->whereHas("currency",function($q) use ($sender_currency) {
            $q->where("code",$sender_currency->code)->active();
        })->active()->first();
        if(!$userWallet) return Response::error([__('User wallet not found')]);

        $to_country = Currency::where('id',$request->to_country)->active()->first();
        if(!$to_country) return Response::error([__('Receiver country not found')]);

        $charges = $this->chargeCalculate($sender_currency,$to_country,$validated['send_amount'],$exchangeCharge,$transaction_type);

        if($transaction_type == slug(GlobalConst::TRX_BANK_TRANSFER)){
            $sender_currency_rate = $sender_currency->rate / $exchangeCharge->rate;
        }else{
            $sender_currency_rate = $sender_currency->rate;
        }
        
        $min_amount             = $exchangeCharge->min_limit * $sender_currency_rate;
        $max_amount             = $exchangeCharge->max_limit * $sender_currency_rate;
        if($charges->sender_amount < $min_amount || $charges->sender_amount > $max_amount) return Response::error([__('Please follow the transaction limit')]);

        if($charges->payable > $userWallet->balance) Response::error([__('Sorry, insufficient balance')]);


        try{
            if($transaction_type === Str::slug(GlobalConst::TRX_WALLET_TO_WALLET_TRANSFER)){
                $receiver_user =  json_decode($recipient->details);
                $receiver_user =  $receiver_user->id;
                $receiver_wallet = UserWallet::where('user_id',$receiver_user)->active()->whereHas("currency",function($q) use ($to_country) {
                    $q->where("code",$to_country->code)->active();
                })->active()->first();
                if(!$receiver_wallet){
                    return Response::error([__('Receiver wallet not found')]);
                }
                $trx_id = $this->trx_id;
                $sender = $this->insertSender($trx_id,$user,$userWallet,$charges,$recipient,$sender_currency,$to_country,$transaction_type);
                if($sender){
                     $this->insertSenderCharges($sender,$charges,$user,$recipient);
                }
                $receiverTrans = $this->insertReceiver($trx_id,$user,$charges,$recipient,$sender_currency,$to_country,$transaction_type,$receiver_user,$receiver_wallet);
                if($receiverTrans){
                     $this->insertReceiverCharges($receiverTrans,$charges,$user,$receiver_wallet);
                }
                session()->forget('remittance_token');

            }else{
                $trx_id = $this->trx_id;
                $sender = $this->insertSender($trx_id,$user,$userWallet,$charges,$recipient,$sender_currency,$to_country,$transaction_type);
                if($sender){
                     $this->insertSenderCharges($sender,$charges,$user,$recipient);
                     session()->forget('remittance_token');
                }
                if( $basic_setting->email_notification == true){
                        $notifyData = [
                            'trx_id'            => $trx_id,
                            'title'             => __("Send Remittance to")." @" . $recipient->firstname.' '.@$recipient->lastname." (".@$recipient->email.")",
                            'request_amount'    => get_amount($charges->sender_amount,$charges->sender_cur_code),
                            'exchange_rate'     => get_amount(1,$charges->sender_cur_code).' = '.get_amount($charges->exchange_rate,$charges->receiver_cur_code),
                            'charges'           => get_amount($charges->sender_amount,$charges->sender_cur_code),
                            'payable'           => get_amount($charges->payable,$charges->sender_cur_code),
                            'sending_country'   => @$sender_currency->name,
                            'receiving_country' => @$to_country->name,
                            'receiver_name'     => @$recipient->firstname.' '.@$recipient->lastname,
                            'alias'             =>  ucwords(str_replace('-', ' ', @$recipient->alias)),
                            'transaction_type'  =>  @$transaction_type,
                            'receiver_get'      =>  get_amount($charges->will_get,$charges->receiver_cur_code),
                            'status'            => __("Pending"),
                        ];
                        //sender notifications
                        try{
                            $user->notify(new BankTransferMail($user,(object)$notifyData));
                        }catch(Exception $e){}
                }
            }
            if($transaction_type != Str::slug(GlobalConst::TRX_WALLET_TO_WALLET_TRANSFER)){
                $this->adminNotification($trx_id,$charges,$user,$recipient,$to_country,$sender_currency,$transaction_type);
            }

            Session::flash('success', [__('Remittance Money send successfully')]);
            return Response::success(['success' => [__('Remittance Money send successfully')]],['url' => route('user.remittance.index')]);
        }catch(Exception $e) {
            return Response::error([__("Something went wrong! Please try again.")]);
        }

    }

    //sender transaction
    public function insertSender($trx_id,$user,$userWallet,$charges,$recipient,$sender_currency,$to_country,$transaction_type) {
            $trx_id = $trx_id;
            $authWallet = $userWallet;
            $afterCharge = ($authWallet->balance - $charges->payable);
            $details =[
                'recipient_amount' => $charges->will_get,
                'receiver' => $recipient,
                'form_country' => $sender_currency->name,
                'to_country' => $to_country,
                'remitance_type' => $transaction_type,
                'sender' => $user,
                'bank_account' => $recipient->account_number??'',
                'charges' => $charges,
            ];
            if($transaction_type == Str::slug(GlobalConst::TRX_WALLET_TO_WALLET_TRANSFER)){
                $status = 1;
            }else{
                $status = 2;
            }
            DB::beginTransaction();
            try{
                $id = DB::table("transactions")->insertGetId([
                    'user_id'                       => $user->id,
                    'user_wallet_id'                => $authWallet->id,
                    'payment_gateway_currency_id'   => null,
                    'type'                          => PaymentGatewayConst::SENDREMITTANCE,
                    'trx_id'                        => $trx_id,
                    'request_amount'                => $charges->sender_amount,
                    'payable'                       => $charges->payable,
                    'available_balance'             => $afterCharge,
                    'remark'                        => ucwords(remove_speacial_char(PaymentGatewayConst::SENDREMITTANCE," ")) . " To " .$recipient->fullname,
                    'details'                       => json_encode($details),
                    'attribute'                      =>PaymentGatewayConst::SEND,
                    'status'                        => $status,
                    'created_at'                    => now(),
                ]);
                $this->updateSenderWalletBalance($authWallet,$afterCharge);

                DB::commit();
            }catch(Exception $e) {
                DB::rollBack();
                throw new Exception(__("Something went wrong! Please try again."));
            }
            return $id;
    }
    public function updateSenderWalletBalance($authWallet,$afterCharge) {
        $authWallet->update([
            'balance'   => $afterCharge,
        ]);
    }
    public function insertSenderCharges($id,$charges,$user,$recipient){
        DB::beginTransaction();
        try{
            DB::table('transaction_charges')->insert([
                'transaction_id'    =>  $id,
                'percent_charge'    =>  $charges->percent_charge,
                'fixed_charge'      =>  $charges->fixed_charge,
                'total_charge'      =>  $charges->total_charge,
                'created_at'        => now(),
            ]);
            DB::commit();

            //notification
            $notification_content = [
                'title'         =>__("Send Remittance"),
                'message'       => __("Send Remittance Request to")." ".$recipient->fullname.' ' .get_amount($charges->sender_amount,$charges->sender_cur_code)." ".__("Successful"),
                'image'         => get_image($user->image,'user-profile'),
            ];

            UserNotification::create([
                'type'      => NotificationConst::SEND_REMITTANCE,
                'user_id'  => $user->id,
                'message'   => $notification_content,
            ]);

            //Push Notifications
           try{
            (new PushNotificationHelper())->prepare([$user->id],[
                'title' => $notification_content['title'],
                'desc'  => $notification_content['message'],
                'user_type' => 'user',
            ])->send();
           }catch(Exception $e) {}

        }catch(Exception $e) {
            DB::rollBack();
            throw new Exception(__("Something went wrong! Please try again."));
        }
    }
    //Receiver Transaction
    public function insertReceiver($trx_id,$user,$charges,$recipient,$sender_currency,$to_country,$transaction_type,$receiver_user,$receiver_wallet) {

        $trx_id = $trx_id;
        $receiverWallet = $receiver_wallet;
        $recipient_amount = ($receiverWallet->balance + $charges->will_get);
        $details =[
            'recipient_amount'  => $charges->will_get,
            'receiver'          => $recipient,
            'form_country'      => $sender_currency->name,
            'to_country'        => $to_country,
            'remitance_type'    => $transaction_type,
            'sender'            => $user,
            'bank_account'      => $recipient->account_number??'',
            'charges'           => $charges,
        ];
        DB::beginTransaction();
        try{
            $id = DB::table("transactions")->insertGetId([
                'user_id'                       => $receiver_user,
                'user_wallet_id'                => $receiverWallet->id,
                'payment_gateway_currency_id'   => null,
                'type'                          => PaymentGatewayConst::SENDREMITTANCE,
                'trx_id'                        => $trx_id,
                'request_amount'                => $charges->sender_amount,
                'payable'                       => $charges->will_get,
                'available_balance'             => $recipient_amount,
                'remark'                        => ucwords(remove_speacial_char(PaymentGatewayConst::RECEIVEREMITTANCE," ")) . " From " .$user->fullname,
                'details'                       => json_encode($details),
                'attribute'                      =>PaymentGatewayConst::RECEIVED,
                'status'                        => true,
                'created_at'                    => now(),
            ]);
            $this->updateReceiverWalletBalance($receiverWallet,$recipient_amount);

            DB::commit();
        }catch(Exception $e) {
            DB::rollBack();
            throw new Exception(__("Something went wrong! Please try again."));
        }
        return $id;
    }
    public function updateReceiverWalletBalance($receiverWallet,$recipient_amount) {
        $receiverWallet->update([
            'balance'   => $recipient_amount,
        ]);
    }
    public function insertReceiverCharges($id,$charges,$user,$receiver_wallet) {
        DB::beginTransaction();
        try{
            DB::table('transaction_charges')->insert([
                'transaction_id'    =>  $id,
                'percent_charge'    =>  0,
                'fixed_charge'      =>  0,
                'total_charge'      =>  0,
                'created_at'        => now(),
            ]);
            DB::commit();

            //notification
            $notification_content = [
                'title'         =>__("Send Remittance"),
                'message'       => __("Send Remittance From")." ".$user->fullname.' ' .get_amount($charges->will_get,$charges->receiver_cur_code)." ".__('Successful'),
                'image'         => get_image($receiver_wallet->user->image,'user-profile'),
            ];

            UserNotification::create([
                'type'      => NotificationConst::SEND_REMITTANCE,
                'user_id'  => $receiver_wallet->user->id,
                'message'   => $notification_content,
            ]);

            //Push Notifications
           try{
            (new PushNotificationHelper())->prepare([$receiver_wallet->user->id],[
                'title' => $notification_content['title'],
                'desc'  => $notification_content['message'],
                'user_type' => 'user',
            ])->send();
           }catch(Exception $e) {}
        }catch(Exception $e) {
            DB::rollBack();
            throw new Exception(__("Something went wrong! Please try again."));
        }
    }
    //end transaction helpers
    public function getToken() {
        $data = request()->all();
        $in['receiver_country'] = $data['receiver_country'];
        $in['transacion_type'] = $data['transacion_type'];
        $in['recipient'] = $data['recipient'];
        $in['sender_amount'] = $data['sender_amount'];
        $in['receive_amount'] = $data['receive_amount'];
        Session::put('remittance_token',$in);
        return response()->json($data);

    }
    public function getRecipientByCountry(Request $request){
        $receiver_country = $request->receiver_country;
        $transacion_type = $request->transacion_type;
        if( $transacion_type != null || $transacion_type != ''){
            $data['recipient'] = Receipient::auth()->where('country', $receiver_country)->where('type',$transacion_type)->get();

        }else{
            $data['recipient'] = Receipient::auth()->where('country', $receiver_country)->get();
        }
        return response()->json($data);
    }
    public function getRecipientByTransType(Request $request){
        $receiver_country = $request->receiver_country;
        $transacion_type = $request->transacion_type;
          $data['recipient'] = Receipient::auth()->where('country', $receiver_country)->where('type',$transacion_type)->get();
        return response()->json($data);
    }
    public function getBankMethod(Request $request){
        $alias  = $request->bank;
        $data['bank'] = RemitanceBankDeposit::where('alias',$alias)->first();
        return response()->json($data);
    }
    //admin notification
    public function adminNotification($trx_id,$charges,$user,$recipient,$to_country,$sender_currency,$transaction_type){
        $exchange_rate = get_amount(1,$charges->sender_cur_code).' = '.get_amount($charges->exchange_rate,$charges->receiver_cur_code);
        if($transaction_type == 'bank-transfer'){
            $input_field = "bank Name";
        }else{
            $input_field = "Pickup Point";
        }
        $notification_content = [
            //email notification
            'subject' =>__("Send Remittance to")." @" . $recipient->firstname.' '.@$recipient->lastname." (".@$recipient->email.")",
            'greeting' =>__("Send Remittance Information"),
            'email_content' =>__("web_trx_id")." : ".$trx_id."<br>".__("sender").": @".$user->email."<br>".__("Receiver").": @".$recipient->email."<br>".__("Sender Amount")." : ".get_amount($charges->sender_amount,$charges->sender_cur_code)."<br>".__("Exchange Rate")." : ".$exchange_rate."<br>".__("Fees & Charges")." : ".get_amount($charges->total_charge,$charges->sender_cur_code)."<br>".__("Total Payable Amount")." : ".get_amount($charges->payable,$charges->sender_cur_code)."<br>".__("Recipient Received")." : ".get_amount($charges->will_get,$charges->receiver_cur_code)."<br>".__("Transaction Type")." : ".ucwords(str_replace('-', ' ', @$transaction_type))."<br>".__("sending Country")." : ".$sender_currency->name."<br>".__("Receiving Country")." : ".$to_country->name."<br>".__($input_field)." : ".ucwords(str_replace('-', ' ', @$recipient->alias)),

            //push notification
            'push_title' => __("Send Remittance to")." @". $recipient->firstname.' '.@$recipient->lastname." (".@$recipient->email.")"." ".__('Successful'),
            'push_content' => __('web_trx_id')." ".$trx_id." ".__("sender").": @".$user->email." ".__("Receiver").": @".$recipient->email." ".__("Sender Amount")." : ".get_amount($charges->sender_amount,$charges->sender_cur_code)." ".__("Receiver Amount")." : ".get_amount($charges->will_get,$charges->receiver_cur_code),

            //admin db notification
            'notification_type' =>  NotificationConst::SEND_REMITTANCE,
            'admin_db_title' => "Send Remittance"." ".get_amount($charges->sender_amount,get_default_currency_code())." (".$trx_id.")",
            'admin_db_message' =>"Sender".": @".$user->email.","."Receiver".": @".$recipient->email.","."Sender Amount"." : ".get_amount($charges->sender_amount,$charges->sender_cur_code).","."Receiver Amount"." : ".get_amount($charges->will_get,$charges->receiver_cur_code)
        ];

        try{
            //notification
            (new NotificationHelper())->admin(['admin.remitance.index','admin.remitance.pending','admin.remitance.complete','admin.remitance.canceled','admin.remitance.details','admin.remitance.approved','admin.remitance.rejected','admin.remitance.export.data'])
                                    ->mail(ActivityNotification::class, [
                                            'subject'   => $notification_content['subject'],
                                            'greeting'  => $notification_content['greeting'],
                                            'content'   => $notification_content['email_content'],
                                    ])
                                    ->push([
                                            'user_type' => "admin",
                                            'title' => $notification_content['push_title'],
                                            'desc'  => $notification_content['push_content'],
                                    ])
                                    ->adminDbContent([
                                        'type' => $notification_content['notification_type'],
                                        'title' => $notification_content['admin_db_title'],
                                        'message'  => $notification_content['admin_db_message'],
                                    ])
                                    ->send();


        }catch(Exception $e) {}

    }
    public function chargeCalculate($sender_currency,$receiver_currency,$amount,$charges,$type){
        $exchange_rate = $receiver_currency->rate / $sender_currency->rate;
        if($type == slug(GlobalConst::TRX_BANK_TRANSFER)){
            $bank_rate           = $sender_currency->rate / $charges->rate;
            $percent_charge      = ($amount / 100) * $charges->percent_charge;
            $fixed_charge        = $bank_rate * $charges->fixed_charge;
            $total_charge        = $fixed_charge + $percent_charge;

        }else{
            $bank_rate           = 0;
            $percent_charge      = ($amount / 100) * $charges->percent_charge;
            $fixed_charge        = $sender_currency->rate * $charges->fixed_charge;
            $total_charge        = $fixed_charge + $percent_charge;
        }


        $data['exchange_rate']          = $exchange_rate;
        $data['sender_amount']          = $amount;
        $data['sender_cur_code']        = $sender_currency->code;
        $data['sender_cur_rate']        = $sender_currency->rate;

        $data['receiver_cur_code']      = $receiver_currency->code;
        $data['receiver_cur_rate']      = $receiver_currency->rate;

        $data['percent_charge']         = $percent_charge;
        $data['fixed_charge']           = $fixed_charge;
        $data['total_charge']           = $total_charge;

        $data['conversion_amount']      = $amount * $exchange_rate;
        $data['payable']                = $amount + $data['total_charge'];
        $data['will_get']               = $amount * $exchange_rate;
        $data['bank_rate']              = $bank_rate??0;
        return (object) $data;
    }
}

