

<?php
    $type =  Illuminate\Support\Str::slug(App\Constants\GlobalConst::USEFUL_LINKS);
    $policies = App\Models\Admin\SetupPage::orderBy('id')->where('type', $type)->where('slug',"terms-and-conditions")->where('status',1)->first();
?>

<?php $__env->startSection('content'); ?>
    <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start acount
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<section class="account kyc">
    <div id="body-overlay" class="body-overlay"></div>
    <div class="account-area">
        <div class="account-wrapper kyc">
            <div class="account-logo text-center">
                <a href="<?php echo e(setRoute('index')); ?>" class="site-logo">
                    <img src="<?php echo e(get_logo($basic_settings)); ?>"  data-white_img="<?php echo e(get_logo($basic_settings,'white')); ?>"
                    data-dark_img="<?php echo e(get_logo($basic_settings,'dark')); ?>"
                        alt="site-logo">
                </a>
            </div>
            <h5 class="title"><?php echo e(__("KYC Form")); ?></h5>
            <p><?php echo e(__("Please input all the field for login to your account to get access to your dashboard.")); ?></p>
            <form class="account-form" action="<?php echo e(setRoute('user.register.submit')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="row ml-b-20">
                    <div class="col-xl-4 col-lg-4 col-md-4 form-group">
                        <?php echo $__env->make('admin.components.form.input',[
                            'name'          => "firstname",
                          'placeholder'   => __("first Name"),
                            'value'         => old("firstname"),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-4 col-lg-4 col-md-4 form-group">
                        <?php echo $__env->make('admin.components.form.input',[
                                    'name'          => "lastname",
                                    'placeholder'   => __("last Name"),
                                    'value'         => old("lastname"),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-4 col-lg-4 col-md-4 form-group">
                        <select name="country" class="form--control country-select select2-basic" > </select>
                    </div>
                    <div class="col-xl-4 col-lg-4 col-md-4 form-group">
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text copytext">@</span>
                            </div>
                            <input type="email" name="email" class="form--control" placeholder="Email" value="<?php echo e(old('email',@$email)); ?>" readonly>

                        </div>
                    </div>
                    <div class="col-xl-8 col-lg-8 form-group">
                        <div class="input-group">
                            <div class="input-group-text phone-code">+</div>
                            <input class="phone-code" type="hidden" name="phone_code" value="" />
                            <input type="text" class="form--control" placeholder="<?php echo e(__("enter Phone Number")); ?>" name="phone" value="">
                        </div>
                    </div>					
					<div class="col-xl-12 col-lg-12 form-group">
						<?php echo $__env->make('admin.components.form.input',[
							'name'          => "address",
							 'placeholder'   => __("enter Address"),
							'value'         => old('address')
						], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					</div>	
					<div class="col-xl-4 col-lg-4 form-group">

					<?php echo $__env->make('admin.components.form.input',[
						'name'          => "state",
						'placeholder'   => __('enter State'),
						'value'         => old('state')
					], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					</div>					
                    <div class="col-xl-4 col-lg-4 col-md-4 form-group">
                        <?php echo $__env->make('admin.components.form.input',[
                            'name'          => "city",
                            'placeholder'   =>__( "city"),
                            'value'         => old("city"),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-4 col-lg-4 col-md-4 form-group">
                        <?php echo $__env->make('admin.components.form.input',[
                                    'name'          => "zip_code",
                                 'placeholder'   =>__( "enter Zip Code"),
                                    'value'         => old('zip_code',auth()->user()->address->zip ?? "")
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <?php if($basic_settings->kyc_verification): ?>
                        <?php echo $__env->make('user.components.register-kyc',compact("kyc_fields"), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                    <div class="col-lg-6 col-md-4 form-group show_hide_password" id="">
                        <input type="password" class="form--control" name="password"placeholder="<?php echo e(__('enter Password')); ?>" required>
                        <a href="javascript:void(0)" class="show-pass"><i class="fa fa-eye-slash" aria-hidden="true"></i></a>


                    </div>
                    <div class="col-lg-6 col-md-4 form-group show_hide_password-2" id="">
                        <input type="password" class="form--control" name="password_confirmation"placeholder="<?php echo e(__('confirm Password')); ?>" required>
                        <a href="javascript:void(0)" class="show-pass"><i class="fa fa-eye-slash" aria-hidden="true"></i></a>

                    </div>
                    <?php if($basic_settings->agree_policy): ?>
                    <div class="col-lg-12 form-group">
                        <div class="custom-check-group">
                            <div class="custom-check-group mb-0">
                                <input type="checkbox" id="level-1" name="agree">
                                <label for="level-1" class="mb-0"><?php echo e(__("I have agreed with")); ?> <a href="<?php echo e($policies != null? setRoute('useful.link',$policies->slug):"javascript:void(0)"); ?>"><?php echo e(__("Terms Of Use & Privacy Policy")); ?></a></label>
                            </div>

                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="col-lg-12 form-group text-center">
                        <button type="submit" class="btn--base w-100 btn-loading"><?php echo e(__("Register")); ?> <i class="fas fa-arrow-alt-circle-right ms-1"></i></button>
                    </div>
                    <div class="or-area">
                        <span class="or-line"></span>
                        <span class="or-title">Or</span>
                        <span class="or-line"></span>
                    </div>
                    <div class="col-lg-12 text-center">
                        <div class="account-item">
                            <label><?php echo e(__("already Have An Account")); ?> <a href="<?php echo e(setRoute('user.login')); ?>" class="account-control-btn"><?php echo e(__("Login Now")); ?></a></label>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End acount
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->

<ul class="bg-bubbles">
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
</ul>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
      getAllCountries("<?php echo e(setRoute('global.countries')); ?>");
        $(document).ready(function(){
            $("select[name=country]").on('change',function(){
                var phoneCode = $("select[name=country] :selected").attr("data-mobile-code");
                placePhoneCode(phoneCode);
            });
            countrySelect(".country-select",$(".country-select").siblings(".select2"));


        });
</script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.user_auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/user/auth/register-kyc.blade.php ENDPATH**/ ?>