<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('agent.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("agent.dashboard"),
        ]
    ], 'active' => __(@$page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="body-wrapper">
    <div class="dashboard-area mt-10">
        <div class="dashboard-header-wrapper">
            <h3 class="title"><?php echo e(__(@$page_title)); ?></h3>
        </div>
    </div>
    <div class="row mb-30-none">
        <div class="col-xl-6 mb-30">
            <div class="dash-payment-item-wrapper">
                <div class="dash-payment-item active">
                    <div class="dash-payment-title-area">
                        <span class="dash-payment-badge">!</span>
                        <h5 class="title"><?php echo e(__(@$page_title)); ?></h5>
                    </div>
                    <div class="dash-payment-body">
                        <form class="card-form" action="<?php echo e(setRoute('agent.money.in.confirmed')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-xl-12 col-lg-12 form-group text-center">
                                    <div class="exchange-area">
                                        <code class="d-block text-center"><span class="fees-show">--</span> <span class="limit-show">--</span></code>
                                    </div>
                                </div>
                                <div class="col-xxl-12 col-xl-12 col-lg-12 form-group paste-wrapper">
                                    <label><?php echo e(__("Email")); ?> (<?php echo e(__("User")); ?>)<span class="text--base">*</span></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text copytext"><span><?php echo e(__("Email")); ?></span></span>
                                        </div>
                                        <input type="email" name="email" class="form--control checkUser" id="username" placeholder="<?php echo e(__('enter Email Address')); ?>" value="<?php echo e(old('email')); ?>" />
                                    </div>
                                    <button type="button" class="paste-badge scan"  data-toggle="tooltip" title="Scan QR"><i class="fas fa-camera"></i></button>
                                    <label class="exist text-start"></label>

                                </div>

                                
                                <div class="col-xxl-6 col-xl-12 col-lg-6 form-group">
                                    <label><?php echo e(__("Sender Amount")); ?><span>*</span></label>
                                    <div class="input-group">
                                        <input type="text" class="form--control number-input" required placeholder="<?php echo e(__('enter Amount')); ?>" name="sender_amount" value="<?php echo e(old("amount")); ?>">
                                        <select class="form--control nice-select sender_wallet" name="sender_wallet">
                                            <?php $__currentLoopData = $sender_wallets ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($data->code); ?>" data-rate="<?php echo e($data->rate); ?>" data-currency-id="<?php echo e($data->id); ?>" data-sender-country-name="<?php echo e($data->name); ?>"><?php echo e($data->code); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <code class="d-block mt-10 text-start text--warning balance-show">--</code>
                                </div>
                                <div class="col-xxl-6 col-xl-12 col-lg-6 form-group">
                                    <label><?php echo e(__("Receiver Amount")); ?><span>*</span></label>
                                    <div class="input-group">
                                        <input type="text" class="form--control number-input" required placeholder="<?php echo e(__('enter Amount')); ?>" name="receiver_amount" value="<?php echo e(old("amount")); ?>">
                                        <select class="form--control nice-select receiver_wallet" name="receiver_wallet">
                                            <?php $__currentLoopData = $receiver_wallets ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($data->code); ?>" data-rate="<?php echo e($data->rate); ?>" data-receiver-country-name="<?php echo e($data->name); ?>"><?php echo e($data->code); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-xl-12 col-lg-12 form-group">
                                    <?php echo $__env->make('admin.components.form.textarea',[
                                        'label'         => __("Remarks")." (".__("Optional").")",
                                        'name'          => "remark",
                                        'placeholder'   => __("explain Trx"),
                                        'value'         => old("remark"),
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>

                                <div class="col-xl-12 col-lg-12">
                                    <button type="submit" class="btn--base w-100 btn-loading transfer"><?php echo e(__("Confirm Send")); ?> <i class="fas fa-paper-plane ms-1"></i></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-6 mb-30">
            <div class="dash-payment-item-wrapper">
                <div class="dash-payment-item active">
                    <div class="dash-payment-title-area">
                        <span class="dash-payment-badge">!</span>
                        <h5 class="title"><?php echo e(__(@$page_title)); ?> <?php echo e(__("Preview")); ?></h5>
                    </div>
                    <div class="dash-payment-body">
                        <div class="preview-list-wrapper">
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-wallet"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Sending Wallet")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="fw-bold sending-wallet">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-wallet"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Receiving Wallet")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="fw-bold receiving-wallet">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-coins"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Entered Amount")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="fw-bold request-amount">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-battery-half"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Total Charge")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="fees">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-sync-alt"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Exchange Rate")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="exchange-rate">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-receipt"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Recipient Received")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="recipient-get">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-money-check-alt"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Total Payable")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="last payable-total text-warning">--</span>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="dashboard-list-area mt-20">
        <div class="dashboard-header-wrapper">
            <h4 class="title "><?php echo e(__("Money In Log")); ?></h4>
            <div class="dashboard-btn-wrapper">
                <div class="dashboard-btn mb-2">
                    <a href="<?php echo e(setRoute('agent.transactions.index','money-in')); ?>" class="btn--base"><?php echo e(__("View More")); ?></a>
                </div>
            </div>
        </div>
        <div class="dashboard-list-wrapper">
            <?php echo $__env->make('agent.components.transaction-log',compact("transactions"), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<div class="modal fade" id="scanModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
            <div class="modal-body text-center">
                <video id="preview" class="p-1 border" style="width:300px;"></video>
            </div>
            <div class="modal-footer justify-content-center">
              <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal"><?php echo app('translator')->get('close'); ?></button>
            </div>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script src="https://rawgit.com/schmich/instascan-builds/master/instascan.min.js"></script>
<script>
    //'use strict'
    (function ($) {
        $('.scan').click(function(){
            var scanner = new Instascan.Scanner({ video: document.getElementById('preview'), scanPeriod: 5, mirror: false });
            scanner.addListener('scan',function(content){
                var route = '<?php echo e(url('agent/user/qr/scan/')); ?>'+'/'+content
                $.get(route, function( data ) {
                    if(data.error){
                        // alert(data.error)
                        throwMessage('error',[data.error]);
                    } else {
                        $("#username").val(data);
                        $("#username").focus()
                    }
                    $('#scanModal').modal('hide')
                });
            });

            Instascan.Camera.getCameras().then(function (cameras){
                if(cameras.length>0){
                    $('#scanModal').modal('show')
                        scanner.start(cameras[0]);
                } else{
                //    alert('No cameras found.');
                    throwMessage('error',["No camera found "]);
                }
            }).catch(function(e){
                // alert('No cameras found.');
                throwMessage('error',["No camera found "]);
            });
        });
        $('.checkUser').on('keyup',function(e){
            var url = '<?php echo e(route('agent.money.in.check.exist')); ?>';
            var value = $(this).val();
            var token = '<?php echo e(csrf_token()); ?>';
            if ($(this).attr('name') == 'email') {
                var data = {email:value,_token:token}

            }
            $.post(url,data,function(response) {
                if(response.own){
                    if($('.exist').hasClass('text--success')){
                        $('.exist').removeClass('text--success');
                    }
                    $('.exist').addClass('text--danger').text(response.own);
                    $('.transfer').attr('disabled',true)
                    return false
                }
                if(response['data'] != null){
                    if($('.exist').hasClass('text--danger')){
                        $('.exist').removeClass('text--danger');
                    }
                    $('.exist').text(`Valid user for transaction.`).addClass('text--success');
                    $('.transfer').attr('disabled',false)
                } else {
                    if($('.exist').hasClass('text--success')){
                        $('.exist').removeClass('text--success');
                    }
                    $('.exist').text('User doesn\'t  exists.').addClass('text--danger');
                    $('.transfer').attr('disabled',true)
                    return false
                }

            });
        });
    })(jQuery);
</script>

<script>
    var defualCurrency = "<?php echo e(get_default_currency_code()); ?>";
    var defualCurrencyRate = "<?php echo e(get_default_currency_rate()); ?>";

       $(document).ready(function(){
           senderBalance();
           getExchangeRate()
           getLimit();
           getFees();
           getReceiverAmount();
           getSenderAmount();
           getPreview();
       });
       $("input[name=sender_amount]").keyup(function(){
           getExchangeRate();
           getFees();
           getReceiverAmount();
           getPreview();
       });
       $("input[name=receiver_amount]").keyup(function(){
           getExchangeRate();
           getFees();
           getSenderAmount();
           getPreview();
       });
       $("select[name=sender_wallet]").change(function(){
           senderBalance();
           getExchangeRate();
           getLimit();
           getFees();
           getReceiverAmount();
           getPreview();
       });
       $("select[name=receiver_wallet]").change(function(){
           senderBalance();
           getExchangeRate();
           getLimit();
           getFees();
           getSenderAmount();
           getPreview();
       });

       function acceptVar(){
           var defualCurrency          = defualCurrency;
           var defualCurrencyRate      = defualCurrencyRate;

           var senderCurrencyVal       = $("select[name=sender_wallet] :selected");
           var senderCurrencyCode      = $("select[name=sender_wallet] :selected").val();
           var senderCurrencyRate      = $("select[name=sender_wallet] :selected").data('rate');

           var receiverCurrencyVal     = $("select[name=receiver_wallet] :selected");
           var receiverCurrencyCode    = $("select[name=receiver_wallet] :selected").val();
           var receiverCurrencyRate    = $("select[name=receiver_wallet] :selected").data('rate');

           var currencyMinAmount       = "<?php echo e(getAmount($moneyInCharge->min_limit)); ?>"
           var currencyMaxAmount       = "<?php echo e(getAmount($moneyInCharge->max_limit)); ?>"
           var currencyFixedCharge     = "<?php echo e(getAmount($moneyInCharge->fixed_charge)); ?>"
           var currencyPercentCharge   = "<?php echo e(getAmount($moneyInCharge->percent_charge)); ?>"

           return {
               defualCurrency:defualCurrency,
               defualCurrencyRate:defualCurrencyRate,

               sCurrencyVal:senderCurrencyVal,
               sCurrencyCode:senderCurrencyCode,
               sCurrencyRate:senderCurrencyRate,

               rCurrencyVal:receiverCurrencyVal,
               rCurrencyCode:receiverCurrencyCode,
               rCurrencyRate:receiverCurrencyRate,

               currencyMinAmount:currencyMinAmount,
               currencyMaxAmount:currencyMaxAmount,

               currencyFixedCharge:currencyFixedCharge,
               currencyPercentCharge:currencyPercentCharge,

           };
       }
       function getLimit(){
           var sender_currency = acceptVar().sCurrencyCode;
           var sender_currency_rate = acceptVar().sCurrencyRate;
           var min_limit = acceptVar().currencyMinAmount;
           var max_limit = acceptVar().currencyMaxAmount

           if($.isNumeric(min_limit) && $.isNumeric(max_limit)) {
               var min_limit_calc = parseFloat(min_limit*sender_currency_rate).toFixed(2);
               var max_limit_clac = parseFloat(max_limit*sender_currency_rate).toFixed(2);
               $('.limit-show').html("<?php echo e(__('limit')); ?> " + min_limit_calc + " " + sender_currency + " - " + max_limit_clac + " " + sender_currency);
               return {
                   minLimit:min_limit_calc,
                   maxLimit:max_limit_clac,
               };
           }else {
               $('.limit-show').html("--");
               return {
                   minLimit:0,
                   maxLimit:0,
               };
           }
       }
       function feesCalculation(){
           var sender_currency = acceptVar().sCurrencyCode;
           var sender_currency_rate = acceptVar().sCurrencyRate;
           var sender_amount = $("input[name=sender_amount]").val();
           sender_amount == "" ? sender_amount = 0 : sender_amount = sender_amount;

           var fixed_charge = acceptVar().currencyFixedCharge;
           var percent_charge = acceptVar().currencyPercentCharge;

           if($.isNumeric(percent_charge) && $.isNumeric(fixed_charge) && $.isNumeric(sender_amount)) {
               // Process Calculation
               var fixed_charge_calc = parseFloat(sender_currency_rate*fixed_charge);
               var percent_charge_calc  = (parseFloat(sender_amount) / 100) * parseFloat(percent_charge);
               var total_charge = parseFloat(fixed_charge_calc) + parseFloat(percent_charge_calc);
               total_charge = parseFloat(total_charge).toFixed(2);
               // return total_charge;
               return {
                   total: total_charge,
                   fixed: fixed_charge_calc,
                   percent: percent_charge_calc,
               };
           }else {
               // return "--";
               return false;
           }
       }
       function getFees(){
           var sender_currency = acceptVar().sCurrencyCode;
           var percent = acceptVar().currencyPercentCharge;
           var charges = feesCalculation();
           if (charges == false) {
               return false;
           }
           $(".fees-show").html("<?php echo e(__('Transfer Fee')); ?>: " + parseFloat(charges.fixed).toFixed(2) + " " + sender_currency + " + " + parseFloat(percent).toFixed(2) + "%  ");
       }
       function getPreview(){
           var sender_currency = acceptVar().sCurrencyCode;
           var sender_currency_rate = acceptVar().sCurrencyRate;

           var receiver_currency = acceptVar().rCurrencyCode;
           var receiver_currency_rate = acceptVar().rCurrencyRate;

           var senderAmount = $("input[name=sender_amount]").val();
           senderAmount == "" ? senderAmount = 0 : senderAmount = senderAmount;

           var receiverAmount = $("input[name=receiver_amount]").val();
           receiverAmount == "" ? receiverAmount = 0 : receiverAmount = receiverAmount;

           $(".sending-wallet").text(sender_currency + " (" + acceptVar().sCurrencyVal.data('sender-country-name') + ")");
           $(".receiving-wallet").text(receiver_currency + " (" + acceptVar().rCurrencyVal.data('receiver-country-name') + ")");

           // Sending Amount
           $('.request-amount').text(senderAmount + " " + sender_currency);

           // // Fees
           var charges = feesCalculation();
           var total_charge = 0;
           if(senderAmount == 0){
               total_charge = 0;
           }else{
               total_charge = charges.total;
           }

           $('.fees').text(total_charge + " " + sender_currency);
           //recipient received
           $('.recipient-get').text(parseFloat(receiverAmount).toFixed(2) + " " + receiver_currency);

               // Pay In Total
           var totalPay = parseFloat(senderAmount)
           var pay_in_total = 0;
           if(senderAmount == 0){
                   pay_in_total = 0;
           }else{
                   pay_in_total =  parseFloat(totalPay) + parseFloat(charges.total);
           }
           $('.payable-total').text(parseFloat(pay_in_total).toFixed(2) + " " + sender_currency);

       }

       function senderBalance() {
           var senderCurrency = acceptVar().sCurrencyCode;
           var csrfToken = $('meta[name="csrf-token"]').attr('content');
           $.ajax({
               type: 'POST',
               url: "<?php echo e(route('agent.wallets.balance')); ?>",
               data: {
                   target: senderCurrency,
                   _token: csrfToken
               },
               success: function(response) {
                   $('.balance-show').html("<?php echo e(__('Available Balance')); ?>: " + parseFloat(response.data).toFixed(2) + " " + senderCurrency);
               }
           });
       }
       function getExchangeRate(){
           var sender_currency = acceptVar().sCurrencyCode;
           var sender_currency_rate = acceptVar().sCurrencyRate;
           var receiver_currency = acceptVar().rCurrencyCode;
           var receiver_currency_rate = acceptVar().rCurrencyRate;
           var rate = parseFloat(receiver_currency_rate) / parseFloat(sender_currency_rate);
           $('.exchange-rate').html("1 " + sender_currency + " = " + parseFloat(rate).toFixed(2) + " " + receiver_currency);

           return rate;
       }
       function getReceiverAmount(){
           var sender_currency = acceptVar().sCurrencyCode;
           var sender_currency_rate = acceptVar().sCurrencyRate;

           var receiver_currency = acceptVar().rCurrencyCode;
           var receiver_currency_rate = acceptVar().rCurrencyRate;

           var sender_amount = $("input[name=sender_amount]").val();
           var receiver_amount = $("input[name=receiver_amount]");

           if($.isNumeric(sender_amount)) {
               var rate = parseFloat(receiver_currency_rate) / parseFloat(sender_currency_rate);
               var receiver_will_get = parseFloat(rate) * parseFloat(sender_amount);
               receiver_will_get = parseFloat(receiver_will_get).toFixed(2);
               receiver_amount.val(receiver_will_get);
               preview_receiver_will_get = receiver_will_get;
           }else {
               receiver_amount.val("");
               preview_receiver_will_get = "0";
           }
       }
       function getSenderAmount(){
           var sender_currency = acceptVar().sCurrencyCode;
           var sender_currency_rate = acceptVar().sCurrencyRate;

           var receiver_currency = acceptVar().rCurrencyCode;
           var receiver_currency_rate = acceptVar().rCurrencyRate;

           var sender_amount = $("input[name=sender_amount]");
           var receiver_amount = $("input[name=receiver_amount]").val();

           if($.isNumeric(receiver_amount)) {
               var rate = parseFloat(sender_currency_rate) / parseFloat(receiver_currency_rate);
               var sender_will_get = parseFloat(rate) * parseFloat(receiver_amount);
               sender_will_get = parseFloat(sender_will_get).toFixed(2);
               sender_amount.val(sender_will_get);
               preview_receiver_will_get = parseFloat(receiver_amount);
           }else {
               sender_amount.val("");
               preview_receiver_will_get = "0";
           }
       }

</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('agent.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp-8.0.2\htdocs\qrpay\v4.5.0\multiple\resources\views/agent/sections/money-in/index.blade.php ENDPATH**/ ?>