<?php if($basic_settings->agent_kyc_verification == true && isset($kyc_data) && $kyc_data != null && $kyc_data->fields != null): ?>

<div class="custom-card mt-30">
    <div class="dashboard-header-wrapper">
        <h4 class="title"><?php echo e(__("KYC Information")); ?> &nbsp; <span class="<?php echo e(auth()->user()->kycStringStatus->class); ?>"><?php echo e(__(auth()->user()->kycStringStatus->value)); ?></span></h4>
    </div>
    <div class="card-body">
        <?php if(auth()->user()->kyc_verified == global_const()::PENDING): ?>
            <div class="pending text--warning kyc-text"><?php echo e(__("pendingKycText")); ?></div>
        <?php elseif(auth()->user()->kyc_verified == global_const()::APPROVED): ?>
            <div class="approved text--success kyc-text"><?php echo e(__("verifiedKycText")); ?></div>
            <ul class="kyc-data">
                <?php $__currentLoopData = auth()->user()->kyc->data ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                        <?php if($item->type == "file"): ?>
                            <?php
                                $file_link = get_file_link("kyc-files",$item->value);
                            ?>
                            <span class="kyc-title"><?php echo e($item->label); ?>:</span>
                            <?php if(its_image($item->value)): ?>
                                <div class="kyc-image ">
                                    <img class="img-fluid" width="200px" src="<?php echo e($file_link); ?>" alt="<?php echo e($item->label); ?>">
                                </div>
                            <?php else: ?>
                                <span class="text--danger">
                                    <?php
                                        $file_info = get_file_basename_ext_from_link($file_link);
                                    ?>
                                    <a href="<?php echo e(setRoute('file.download',["kyc-files",$item->value])); ?>" >
                                        <?php echo e(Str::substr($file_info->base_name ?? "", 0 , 20 ) ."..." . $file_info->extension ?? ""); ?>

                                    </a>
                                </span>
                            <?php endif; ?>
                        <?php else: ?>
                            <span class="kyc-title"><?php echo e($item->label); ?>:</span>
                            <span><?php echo e($item->value); ?></span>
                        <?php endif; ?>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        <?php elseif(auth()->user()->kyc_verified == global_const()::REJECTED): ?>
            <div class="unverified text--danger kyc-text d-flex align-items-center justify-content-between mb-4">
                <div class="title text--warning"><?php echo e(__("rejectedKycKey")); ?></div>
                <a href="<?php echo e(setRoute('agent.authorize.kyc')); ?>" class="btn--base"><?php echo e(__("Verify KYC")); ?></a>
            </div>
            <div class="rejected">
                <div class="rejected-reason"><?php echo e(auth()->user()->kyc->reject_reason ?? ""); ?></div>
            </div>
        <?php else: ?>
            <div class="unverified kyc-text d-flex align-items-center justify-content-between">
                <div class="title"><?php echo e(__("verifyKycInformation")); ?></div>
                <a href="<?php echo e(setRoute('agent.authorize.kyc')); ?>" class="btn--base"><?php echo e(__("Verify KYC")); ?></a>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php endif; ?>
<?php /**PATH E:\xampp-8.0.2\htdocs\qrpay\v4.5.0\multiple\resources\views/agent/components/profile/kyc.blade.php ENDPATH**/ ?>