<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title', ['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __(@$page_title),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="table-area">
        <div class="table-wrapper">

            <div class="table-header">
                <h5 class="title"><?php echo e($page_title); ?></h5>
                <?php if(count($transactions) > 0): ?>
                <div class="table-btn-area">
                    <a href="<?php echo e(setRoute('admin.virtual.card.export.data')); ?>" class="btn--base"><i class="fas fa-download me-1"></i><?php echo e(__("Export Data")); ?></a>
                </div>
            <?php endif; ?>
            </div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__("TRX ID")); ?></th>
                            <th><?php echo e(__("User")); ?></th>
                            <th><?php echo e(__("type")); ?></th>
                            <th><?php echo e(__("Amount")); ?></th>
                            <th><?php echo e(__("charge")); ?></th>
                            <th><?php echo e(__("card Amount")); ?></th>
                            <th><?php echo e(__(("Status"))); ?></th>
                            <th><?php echo e(__("Time")); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $transactions ??[]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                            <tr>
                                <td><?php echo e($item->trx_id); ?></td>
                                <td>
                                    <a href="<?php echo e(setRoute('admin.users.details',$item->user->username)); ?>"><span class="text-info"><?php echo e($item->user->fullname); ?></span></a>
                                </td>

                                <td><?php echo e(__(@$item->remark)); ?></td>
                                <td><?php echo e(get_amount($item->request_amount,$item->details->charges->card_currency??get_default_currency_code())); ?> </td>
                                <td><?php echo e(get_amount($item->charge->total_charge,$item->user_wallet->currency->code)); ?></td>
                                <td>
                                    <?php
                                        $card_number = $item->details->card_info->card_pan?? $item->details->card_info->maskedPan ?? $item->details->card_info->card_number ?? "";
                                    ?>
                                    <?php if($card_number): ?>
                                        <?php
                                            $card_pan = str_split($card_number, 4);
                                        ?>
                                        <?php $__currentLoopData = $card_pan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="text--base fw-bold"><?php echo e($value); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <span class="text--base fw-bold">----</span>
                                        <span class="text--base fw-bold">----</span>
                                        <span class="text--base fw-bold">----</span>
                                        <span class="text--base fw-bold">----</span>
                                    <?php endif; ?>
                                </td>

                                <td>
                                    <span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?></span>
                                </td>
                                <td><?php echo e($item->created_at->format('d-m-y h:i:s A')); ?></td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php echo $__env->make('admin.components.alerts.empty',['colspan' => 9], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php echo e(get_paginate($transactions)); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/admin/sections/virtual-card/logs.blade.php ENDPATH**/ ?>