<?php $__env->startPush('css'); ?>
    <style>
        .copy-button {
            cursor: pointer;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('merchant.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("merchant.dashboard"),
        ]
    ], 'active' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="body-wrapper">
    <div class="row mb-20-none">
        <div class="col-xl-12 col-lg-12 mb-20">
            <div class="custom-card mt-10">
                <div class="dashboard-header-wrapper">
                    <h5 class="title"><?php echo e(__($page_title)); ?></h5>
                </div>
                <div class="row mb-30-none">
                    <div class="col-xxl-4 col-xl-6 col-md-6 mb-20">
                        <div class="gateway-item">
                            <div class="gateway-item-wrapper">
                                <div class="content">
                                    <h4 class="title"><?php echo e(__("wallet Balance")); ?></h4>
                                    <span><i class="las la-exclamation-circle"></i><?php echo e(__("enable Or Disable This Features")); ?></span>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" name="wallet_status" type="checkbox" id="walletStatusCheckbox" <?php echo e(@$setting->wallet_status == 1 ?'checked' :''); ?> >
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-4 col-xl-6 col-md-6 mb-20">
                        <div class="gateway-item">
                            <div class="gateway-item-wrapper">
                                <div class="content">
                                    <h4 class="title"><?php echo e(__("Virtual Card")); ?></h4>
                                    <span><i class="las la-exclamation-circle"></i><?php echo e(__("enable Or Disable This Features")); ?></span>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="virtualStatusCheckbox" <?php echo e(@$setting->virtual_card_status == 1 ?'checked' :''); ?>>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-4 col-xl-6 col-md-6 mb-20">
                        <div class="gateway-item">
                            <div class="gateway-item-wrapper">
                                <div class="content">
                                    <h4 class="title"><?php echo e(__("Master / Visa Card")); ?> <small class="text--base">(<?php echo e(__("Stripe")); ?>)</small></h4>
                                    <span><i class="las la-exclamation-circle"></i><?php echo e(__("enable Or Disable This Features")); ?></span>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input master-visa-switch" type="checkbox" id="masterVisaStatusCheckBox" <?php echo e(@$setting->master_visa_status == 1 ?'checked' :''); ?>>
                                </div>
                            </div>
                            <form class="master-visa-api-form mt-20 <?php echo e(@$setting->master_visa_status == 1 ?'active' :''); ?>" id="master" action="<?php echo e(setRoute('merchant.gateway.setting.update.master.card.credentials')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="api-input-wrapper mb-20-none">
                                    <div class="form-group">
                                        <label><?php echo e(__("primary Key")); ?> <span class="text--base">*</span></label>
                                        <input type="text" name="primary_key" placeholder="<?php echo e(__("primary Key")); ?>" class="form--control" value="<?php echo e(@$setting->credentials->primary_key); ?>" required>
                                    </div>
                                    <div class="form-group">
                                        <label><?php echo e(__("secret Key")); ?> <span class="text--base">*</span></label>
                                        <input type="text" name="secret_key" placeholder="<?php echo e(__("secret Key")); ?>" class="form--control" value="<?php echo e(@$setting->credentials->secret_key); ?>" required>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn--base"><?php echo e(__("Save & Change")); ?> <i class="fas fa-check-circle ms-1"></i></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    var app_mode = "<?php echo e(env('APP_MODE')); ?>"
    $(document).ready(function() {
        //wallet system
        $('#walletStatusCheckbox').on('change', function() {
            var status = this.checked ? 1 : 0;
            if(app_mode == "demo"){
                throwMessage('error',["Can't change anything for demo application."]);
                setTimeout(function wait(){
                    location.reload();
                },2000);
                return false;
            }

            $.ajax({
                url: '<?php echo e(setRoute("merchant.gateway.setting.update.wallet.status")); ?>',
                method: 'POST',
                data: {
                    status: status,
                    _token: '<?php echo e(csrf_token()); ?>'
                 },
                success: function(response) {
                    console.log(response);
                    var updated_status = response.status;
                    if(updated_status == 1){
                        throwMessage('success',["<?php echo e(__('EWallet Balance System Enabled Successfully')); ?>"]);
                    }else{
                        throwMessage('success',["<?php echo e(__('Wallet Balance System Disabled  Successfully')); ?>"]);
                    }
                },
                error: function(xhr, status, error) {

                    throwMessage('error',["Something is wrong!, Please try again later"]);
                }
            });
        });
        //virtual card
        $('#virtualStatusCheckbox').on('change', function() {
            var status = this.checked ? 1 : 0;
            if(app_mode == "demo"){
                throwMessage('error',["Can't change anything for demo application."]);
                setTimeout(function wait(){
                    location.reload();
                },2000);
                return false;
            }

            $.ajax({
                url: '<?php echo e(setRoute("merchant.gateway.setting.update.virtual.status")); ?>',
                method: 'POST',
                data: {
                    status: status,
                    _token: '<?php echo e(csrf_token()); ?>'
                 },
                success: function(response) {
                    var updated_status = response.status;
                    if(updated_status == 1){
                        throwMessage('success',["<?php echo e(__('EVirtual Card System Enabled Successfully')); ?>"]);
                    }else{
                        throwMessage('success',["<?php echo e(__('Virtual Card System Disabled  Successfully')); ?>"]);
                    }
                },
                error: function(xhr, status, error) {
                    throwMessage('error',["Something is wrong!, Please try again later"]);
                }
            });
        });
        //Master/Visa card
        $('#masterVisaStatusCheckBox').on('change', function() {
            var status = this.checked ? 1 : 0;
            if(app_mode == "demo"){
                throwMessage('error',["Can't change anything for demo application."]);
                setTimeout(function wait(){
                    location.reload();
                },2000);
                return false;
            }
            if(status == 1){
                $('#master').addClass('active');
            }else{
                $('#master').removeClass('active');
            }
                $.ajax({
                url: '<?php echo e(setRoute("merchant.gateway.setting.update.master.status")); ?>',
                method: 'POST',
                data: {
                    status: status,
                    _token: '<?php echo e(csrf_token()); ?>'
                 },
                success: function(response) {
                   var updated_status = response.status;
                   if(updated_status == 1){
                    throwMessage('success',["<?php echo e(__('Master/Visa Card System Enabled Successfully')); ?>"]);
                   }else{
                    throwMessage('success',["<?php echo e(__('DMaster/Visa Card System Disabled  Successfully')); ?>"]);
                   }

                },
                error: function(xhr, status, error) {
                    throwMessage('error',["Something is wrong!, Please try again later"]);
                }
            });

        });
    });



</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('merchant.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp-8.0.2\htdocs\qrpay\v4.5.0\multiple\resources\views/merchant/sections/gateway-settings/index.blade.php ENDPATH**/ ?>