<div class="custom-card mb-10">
    <div class="card-header">
        <h6 class="title"><?php echo e($title ?? ""); ?></h6>
    </div>
    <div class="card-body">
        <form class="card-form" method="POST" action="<?php echo e($route ?? ""); ?>">
            <?php echo csrf_field(); ?>
            <?php echo method_field("PUT"); ?>
            <input type="hidden" value="<?php echo e($item->slug); ?>" name="slug">
            <input type="hidden" value="<?php echo e($group->id); ?>" name="group_id">
            <div class="row">
                <div class="<?php echo e($item->agent_profit == true ? 'col-xl-4 col-lg-4': 'col-xl-6 col-lg-6 '); ?> mb-10">
                    <div class="custom-inner-card">
                        <div class="card-inner-header">
                            <h5 class="title"><?php echo e(__("Charges")); ?></h5>
                        </div>
                        <div class="card-inner-body">
                            <div class="row">
                                <div class="col-xxl-12 col-xl-6 col-lg-6 form-group">
                                    <label><?php echo e(__("Fixed Charge*")); ?></label>
                                    <div class="input-group">
                                        <input type="text" class="form--control number-input" value="<?php echo e(old($data->slug.'_fixed_charge',$data->fixed_charge)); ?>" name="<?php echo e($data->slug); ?>_fixed_charge">
                                        <span class="input-group-text"><?php echo e(get_default_currency_code($default_currency)); ?></span>
                                    </div>
                                </div>
                                <div class="col-xxl-12 col-xl-6 col-lg-6 form-group">
                                    <label><?php echo e(__("Percent Charge*")); ?></label>
                                    <div class="input-group">
                                        <input type="text" class="form--control number-input" value="<?php echo e(old($data->slug.'_percent_charge',$data->percent_charge)); ?>" name="<?php echo e($data->slug); ?>_percent_charge">
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="<?php echo e($item->agent_profit == true ? 'col-xl-4 col-lg-4': 'col-xl-6 col-lg-6 '); ?> mb-10">
                    <div class="custom-inner-card">
                        <div class="card-inner-header">
                            <h5 class="title"><?php echo e(__("Range")); ?></h5>
                        </div>
                        <div class="card-inner-body">
                            <div class="row">
                                <div class="col-xxl-12 col-xl-6 col-lg-6  form-group">
                                    <label><?php echo e(__("Minimum amount")); ?></label>
                                    <div class="input-group">
                                        <input type="text" class="form--control number-input" value="<?php echo e(old($data->slug.'_min_limit',$data->min_limit)); ?>" name="<?php echo e($data->slug); ?>_min_limit">
                                        <span class="input-group-text"><?php echo e(get_default_currency_code($default_currency)); ?></span>
                                    </div>
                                </div>
                                <div class="col-xxl-12 col-xl-6 col-lg-6 form-group">
                                    <label><?php echo e(__("Maximum amount")); ?></label>
                                    <div class="input-group">
                                        <input type="text" class="form--control number-input" value="<?php echo e(old($data->slug.'_max_limit',$data->max_limit)); ?>" name="<?php echo e($data->slug); ?>_max_limit">
                                        <span class="input-group-text"><?php echo e(get_default_currency_code($default_currency)); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if( $item->agent_profit == true): ?>
                <div class="col-xl-4 col-lg-4 mb-10">
                    <div class="custom-inner-card">
                        <div class="card-inner-header">
                            <h5 class="title-agent"><?php echo e(__("Agent Profits")); ?></h5>
                        </div>
                        <div class="card-inner-body">
                            <div class="row">
                                <div class="col-xxl-12 col-xl-6 col-lg-6 form-group">
                                    <label><?php echo e(__("Fixed Commissions")); ?></label>
                                    <div class="input-group">
                                        <input type="text" class="form--control number-input" value="<?php echo e(old($data->slug.'_agent_fixed_commissions',$data->agent_fixed_commissions)); ?>" name="<?php echo e($data->slug); ?>_agent_fixed_commissions">
                                        <span class="input-group-text"><?php echo e(get_default_currency_code($default_currency)); ?></span>
                                    </div>
                                </div>
                                <div class="col-xxl-12 col-xl-6 col-lg-6 form-group">
                                    <label><?php echo e(__("Percent Commissions")); ?></label>
                                    <div class="input-group">
                                        <input type="text" class="form--control number-input" value="<?php echo e(old($data->slug.'_agent_percent_commissions',$data->agent_percent_commissions)); ?>" name="<?php echo e($data->slug); ?>_agent_percent_commissions">
                                        <span class="input-group-text"><?php echo e(get_default_currency_code($default_currency)); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            <div class="row mb-10-none">
                <div class="col-xl-12 col-lg-12 form-group">
                    <?php echo $__env->make('admin.components.button.form-btn',[
                        'text'          => "Update",
                        'class'         => "w-100 btn-loading",
                        'permission'    => "admin.setup.group.users.trx.update",
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </form>
    </div>
</div>
<?php /**PATH E:\xampp 8.0.2\htdocs\simple-pay\resources\views/admin/components/charge-group/user-trx-settings-charge-block-edit.blade.php ENDPATH**/ ?>