


<?php
    $lang = selectedLang();
    $auth_slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::AUTH_SECTION);
    $auth_text = App\Models\Admin\SiteSections::getData( $auth_slug)->first();
?>

<?php $__env->startSection('content'); ?>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start acount
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->

<section class="account">
    <div class="account-area">
        <div class="account-wrapper">
            <div class="account-logo text-center">
                <a href="<?php echo e(setRoute('index')); ?>" class="site-logo">
                    <img src="<?php echo e(get_logo_agent($basic_settings)); ?>"  data-white_img="<?php echo e(get_logo_agent($basic_settings,'white')); ?>"
                            data-dark_img="<?php echo e(get_logo_agent($basic_settings,'dark')); ?>"
                                alt="site-logo">
                </a>
            </div>
            <h5 class="title"><?php echo e(__("Log in and Stay Connected")); ?></h5>
            <p><?php echo e(__(@$auth_text->value->language->$lang->login_text)); ?></p>
            <form class="account-form" action="<?php echo e(setRoute('agent.login.submit')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="row ml-b-20">
                    <div class="col-xl-12 col-lg-12 form-group">
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text copytext"><?php echo e(__("Email")); ?></span>
                            </div>
                             <input type="email" name="credentials" class="form--control" placeholder="Enter Email Address" required value="<?php echo e(old('credentials')); ?>">
                        </div>
                    </div>
                    <div class="col-lg-12 form-group" id="show_hide_password">
                        <input type="password" required class="form-control form--control" name="password"placeholder="<?php echo e(__('enter Password')); ?>">
                        <a href="javascript:void(0)" class="show-pass"><i class="fa fa-eye-slash" aria-hidden="true"></i></a>
                    </div>
                    <div class="col-lg-12 form-group">
                        <div class="forgot-item">
                            <label><a href="<?php echo e(setRoute('agent.password.forgot')); ?>"><?php echo e(__("Forgot Password")); ?>?</a></label>
                        </div>
                    </div>
                    <div class="col-lg-12 form-group text-center">
                        <button type="submit" class="btn--base w-100 btn-loading"><?php echo e(__("Login Now")); ?> <i class="las la-arrow-right"></i></button>
                    </div>
                    <?php if($basic_settings->agent_registration): ?>
                    <div class="or-area">
                        <span class="or-line"></span>
                        <span class="or-title"><?php echo e(__("Or")); ?></span>
                        <span class="or-line"></span>
                    </div>
                    <div class="col-lg-12 text-center">
                        <div class="account-item">
                            <label><?php echo e(__("Don't Have An Account?")); ?> <a href="<?php echo e(setRoute('agent.register')); ?>" class="account-control-btn"><?php echo e(__("Register Now")); ?></a></label>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </form>
        </div>
    </div>
</section>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End acount
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->

<ul class="bg-bubbles">
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
    <li></li>
</ul>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    $(document).ready(function() {
        $("#show_hide_password a").on('click', function(event) {
            event.preventDefault();
            if($('#show_hide_password input').attr("type") == "text"){
                $('#show_hide_password input').attr('type', 'password');
                $('#show_hide_password i').addClass( "fa-eye-slash" );
                $('#show_hide_password i').removeClass( "fa-eye" );
            }else if($('#show_hide_password input').attr("type") == "password"){
                $('#show_hide_password input').attr('type', 'text');
                $('#show_hide_password i').removeClass( "fa-eye-slash" );
                $('#show_hide_password i').addClass( "fa-eye" );
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('agent.layouts.user_auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/agent/auth/login.blade.php ENDPATH**/ ?>