<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('user.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("user.dashboard"),
        ]
    ], 'active' => __("profile")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="body-wrapper">
        <div class="row mb-20-none">
            <div class="col-xl-6 col-lg-6 mb-20">
                <div class="custom-card mt-10">
                    <div class="dashboard-header-wrapper">
                        <h4 class="title"><?php echo e(__("Profile Settings")); ?></h4>
                        <a href="javascript:void(0)" class="btn--base btn btn-sm delete-btn"><?php echo e(__("delete Account")); ?></a>
                    </div>
                    <div class="card-body profile-body-wrapper">
                        <form class="card-form" method="POST" action="<?php echo e(setRoute('user.profile.update')); ?> " enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field("PUT"); ?>
                            <div class="profile-settings-wrapper">
                                <div class="preview-thumb profile-wallpaper">
                                    <div class="avatar-preview">
                                        <div class="profilePicPreview bg_img" data-background="<?php echo e(asset('public/frontend/')); ?>/images/element/virtual-card.png"></div>
                                    </div>
                                </div>
                                <div class="profile-thumb-content">
                                    <div class="preview-thumb profile-thumb">
                                        <div class="avatar-preview">
                                            <div class="profilePicPreview bg_img" data-background="<?php echo e(auth()->user()->userImage); ?>"></div>
                                        </div>
                                        <div class="avatar-edit">
                                            <input type='file' class="profilePicUpload" name="image" id="profilePicUpload2"
                                                accept=".png, .jpg, .jpeg" />
                                            <label for="profilePicUpload2"><i class="las la-upload"></i></label>
                                        </div>
                                    </div>
                                    <div class="profile-content">
                                        <h6 class="username"><?php echo e(auth()->user()->username); ?></h6>
                                        <ul class="user-info-list mt-md-2">
                                            <li><i class="las la-envelope"></i><?php echo e(auth()->user()->email); ?></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="profile-form-area">
                                <div class="row">
                                    <div class="col-xl-6 col-lg-6 form-group">
                                        <?php echo $__env->make('admin.components.form.input',[
                                            'label'         => __('first Name')."<span>*</span>",
                                            'name'          => "firstname",
                                            'placeholder'   => __("enter First Name"),
                                            'value'         => old('firstname',auth()->user()->firstname)
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                    <div class="col-xl-6 col-lg-6 form-group">
                                        <?php echo $__env->make('admin.components.form.input',[
                                            'label'         => __('last Name')."<span>*</span>",
                                            'name'          => "lastname",
                                           'placeholder'   => __("enter Last Name"),
                                            'value'         => old('lastname',auth()->user()->lastname)
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                    <div class="col-xl-6 col-lg-6 form-group">
                                        <label><?php echo e(__("country")); ?><span>*</span></label>
                                        <select name="country" class="form--control select2-auto-tokenize country-select" data-placeholder="<?php echo e(__('select Country')); ?>" data-old="<?php echo e(old('country',auth()->user()->address->country ?? "")); ?>"></select>
                                    </div>
                                    <div class="col-xl-6 col-lg-6 form-group">
                                        <label><?php echo e(__("Phone")); ?><span>*</span></label>
                                        <div class="input-group">
                                            <div class="input-group-text phone-code">+<?php echo e(auth()->user()->mobile_code); ?></div>
                                            <input class="phone-code" type="hidden" name="phone_code" value="<?php echo e(auth()->user()->mobile_code); ?>" />
                                            <input type="text" class="form--control" placeholder="<?php echo e(__("enter Phone Number")); ?>" name="phone" value="<?php echo e(old('phone',auth()->user()->mobile)); ?>">
                                        </div>

                                    </div>
                                    <div class="col-xl-6 col-lg-6 form-group">
                                        <?php echo $__env->make('admin.components.form.input',[
                                            'label'         => __("address"),
                                            'name'          => "address",
                                             'placeholder'   => __("enter Address"),
                                            'value'         => old('address',auth()->user()->address->address ?? "")
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                    <div class="col-xl-6 col-lg-6 form-group">
                                        <?php
                                        $old_city = old('city',auth()->user()->address->city ?? "");
                                        ?>
                                        <?php echo $__env->make('admin.components.form.input',[
                                            'label'         => __("city"),
                                            'name'          => "city",
                                            'placeholder'   =>__('enter City'),
                                            'value'         => old('city', $old_city)
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                    </div>
                                    <div class="col-xl-6 col-lg-6 form-group">
                                        <?php
                                        $old_state = old('state',auth()->user()->address->state ?? "");
                                    ?>

                                    <?php echo $__env->make('admin.components.form.input',[
                                        'label'         => __("state"),
                                        'name'          => "state",
                                        'placeholder'   => __('enter State'),
                                        'value'         => old('state', $old_state)
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                    <div class="col-xl-6 col-lg-6 form-group">
                                        <?php echo $__env->make('admin.components.form.input',[
                                            'label'         => __("zip Code"),
                                            'name'          => "zip_code",
                                            'placeholder'   => __('enter Zip Code'),
                                            'value'         => old('zip_code',auth()->user()->address->zip ?? "")
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                </div>
                                <div class="col-xl-12 col-lg-12">
                                    <button type="submit" class="btn--base w-100 btn-loading"><?php echo e(__("update")); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-lg-6 mb-20">
                <div class="custom-card mt-10">
                    <div class="dashboard-header-wrapper">
                        <h4 class="title"><?php echo e(__("Change Password")); ?></h4>
                    </div>
                    <div class="card-body">
                        <form class="card-form" action="<?php echo e(setRoute('user.profile.password.update')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field("PUT"); ?>
                            <div class="row">
                                <div class="col-xl-12 col-lg-12 form-group show_hide_password">
                                    <?php echo $__env->make('admin.components.form.input',[
                                    'label'     => __("Current Password")."<span>*</span>",
                                    'name'      => "current_password",
                                    'type'      => "password",
                                    'placeholder'   => __("enter Password"),
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <a href="javascript:void(0)" class="show-pass profile"><i class="fa fa-eye-slash" aria-hidden="true"></i></a>
                                </div>
                                <div class="col-xl-12 col-lg-12 form-group show_hide_password-2">
                                    <?php echo $__env->make('admin.components.form.input',[
                                     'label'     => __("new Password")."<span>*</span>",
                                    'name'      => "password",
                                    'type'      => "password",
                                    'placeholder'   => __("enter Password"),
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <a href="javascript:void(0)" class="show-pass profile"><i class="fa fa-eye-slash" aria-hidden="true"></i></a>
                                </div>
                                <div class="col-xl-12 col-lg-12 form-group show_hide_password-3">
                                    <?php echo $__env->make('admin.components.form.input',[
                                        'label'     => __("confirm Password")."<span>*</span>",
                                        'name'      => "password_confirmation",
                                        'type'      => "password",
                                        'placeholder'   => __("enter Password"),
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <a href="javascript:void(0)" class="show-pass profile"><i class="fa fa-eye-slash" aria-hidden="true"></i></a>
                                </div>
                            </div>
                            <div class="col-xl-12 col-lg-12">
                                <button type="submit" class="btn--base w-100 btn-loading"><?php echo e(__("Change")); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
                <?php echo $__env->make('user.components.profile.kyc',compact("kyc_data"), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        getAllCountries("<?php echo e(setRoute('global.countries')); ?>");
        $(document).ready(function(){
            $("select[name=country]").change(function(){
                var phoneCode = $("select[name=country] :selected").attr("data-mobile-code");
                placePhoneCode(phoneCode);
            });

            countrySelect(".country-select",$(".country-select").siblings(".select2"));
            stateSelect(".state-select",$(".state-select").siblings(".select2"));

        });
        $(".delete-btn").click(function(){
            var actionRoute =  "<?php echo e(setRoute('user.delete.account')); ?>";
            var target      = 1;
            var btnText = '<?php echo e(__("delete Account")); ?>';
            var projectName = "<?php echo e(@$basic_settings->site_name); ?>";
            var name = $(this).data('name');
            var deleteSureText = '<?php echo e(__("Are you sure to")); ?>';
            var firstText = '<?php echo e(__("If you do not think you will use")); ?>';
            var fullText = '<?php echo e(__("body_text_web")); ?>'

            var message     = `${deleteSureText} <strong> ${btnText}</strong>?<br>${firstText} “<strong>${projectName}</strong>”  ${fullText}, click “${btnText}”.?`;
            openAlertModal(actionRoute,target,message,btnText,"DELETE");
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/user/sections/profile/index.blade.php ENDPATH**/ ?>