<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('agent.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("agent.dashboard"),
        ]
    ], 'active' => __(@$page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="body-wrapper">
    <div class="dashboard-area mt-10">
        <div class="dashboard-header-wrapper">
            <h3 class="title"><?php echo e(__(@$page_title)); ?></h3>
        </div>
    </div>
    <div class="row mb-30-none">
        <div class="col-xl-6 mb-30">
            <div class="dash-payment-item-wrapper">
                <div class="dash-payment-item active">
                    <div class="dash-payment-title-area">
                        <span class="dash-payment-badge">!</span>
                        <h5 class="title"><?php echo e(__("Bill Pay Form")); ?></h5>
                    </div>
                    <div class="dash-payment-body">
                        <form class="card-form" action="<?php echo e(setRoute('agent.bill.pay.confirm')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="exchange_rate">
                            <input type="hidden" name="biller_item_type">
                            <div class="row">
                                <div class="col-xl-12 col-lg-12 form-group text-center">
                                    <div class="exchange-area">
                                        <code class="d-block text-center"><span class="fees-show">--</span> <span class="limit-show">--</span></code>
                                    </div>
                                </div>
                                <div class="col-xxl-6 col-xl-6 col-lg-6 form-group">
                                    <label><?php echo e(__("bill Type")); ?> <span class="text--base">*</span></label>
                                    <select class="form--control" name="bill_type">
                                        <?php $__empty_1 = true; $__currentLoopData = $billType ??[]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php
                                            $type = (object) $type;
                                        ?>
                                            <option value="<?php echo e($type->id); ?>" data-item-type ="<?php echo e($type->item_type); ?>" data-item="<?php echo e(json_encode($type)); ?>" data-name="<?php echo e($type->name); ?>"><?php echo e($type->name); ?> <?php echo e($type->item_type === "MANUAL" ? "(Manual)" : ""); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <option  disabled selected value="null"><?php echo e(__('No Items Available')); ?></option>
                                        <?php endif; ?>

                                    </select>
                                </div>
                                <div class="col-xxl-6 col-xl-6 col-lg-6 form-group">
                                    <label><?php echo e(__("Bill Month")); ?> <span class="text--base">*</span></label>
                                    <select class="form--control" name="bill_month">
                                        <option value="<?php echo e("January".'-'.date("Y")); ?>"><?php echo e("January ".date("Y")); ?></option>
                                        <option value="<?php echo e("February".'-'.date("Y")); ?>"><?php echo e("February ".date("Y")); ?></option>
                                        <option value="<?php echo e("March".'-'.date("Y")); ?>"><?php echo e("March ".date("Y")); ?></option>
                                        <option value="<?php echo e("April".'-'.date("Y")); ?>"><?php echo e("April ".date("Y")); ?></option>
                                        <option value="<?php echo e("May".'-'.date("Y")); ?>"><?php echo e("May ".date("Y")); ?></option>
                                        <option value="<?php echo e("June".'-'.date("Y")); ?>"><?php echo e("June ".date("Y")); ?></option>
                                        <option value="<?php echo e("July".'-'.date("Y")); ?>"><?php echo e("July ".date("Y")); ?></option>
                                        <option value="<?php echo e("August".'-'.date("Y")); ?>"><?php echo e("August ".date("Y")); ?></option>
                                        <option value="<?php echo e("September".'-'.date("Y")); ?>"><?php echo e("September ".date("Y")); ?></option>
                                        <option value="<?php echo e("October".'-'.date("Y")); ?>"><?php echo e("October ".date("Y")); ?></option>
                                        <option value="<?php echo e("November".'-'.date("Y")); ?>"><?php echo e("November ".date("Y")); ?></option>
                                        <option value="<?php echo e("December".'-'.date("Y")); ?>"><?php echo e("December ".date("Y")); ?></option>
                                    </select>
                                </div>
                                <div class="col-xxl-6 col-xl-6 col-lg-6 form-group">
                                    <label><?php echo e(__("Bill Number")); ?> <span class="text--base">*</span></label>
                                    <input type="text" class="form--control number-input" required name="bill_number" placeholder="<?php echo e(__("enter Bill Number")); ?>" value="<?php echo e(old('bill_number')); ?>">

                                </div>

                                <div class="col-xxl-6 col-xl-6 col-lg-6  form-group">
                                    <label><?php echo e(__("Amount")); ?><span>*</span></label>
                                    <div class="input-group">
                                        <input type="text" class="form--control number-input" placeholder="<?php echo e(__('enter Amount')); ?>" name="amount" value="<?php echo e(old("amount")); ?>">
                                        <select class="form--control nice-select currency" name="currency">
                                            <?php $__currentLoopData = $sender_wallets ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($data->code); ?>" data-rate="<?php echo e($data->rate); ?>" data-currency-id="<?php echo e($data->id); ?>" data-sender-country-name="<?php echo e($data->name); ?>"><?php echo e($data->code); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                </div>
                                <div class="col-xl-12 col-lg-12 form-group">
                                    <div class="note-area">
                                        <code class="d-block fw-bold balance-show">-- </code>
                                    </div>
                                </div>

                                <div class="col-xl-12 col-lg-12">
                                    <button type="submit" class="btn--base w-100 btn-loading billPayBtn"><?php echo e(__("pay Bill")); ?> <i class="fas fa-coins ms-1"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-6 mb-30">
            <div class="dash-payment-item-wrapper">
                <div class="dash-payment-item active">
                    <div class="dash-payment-title-area">
                        <span class="dash-payment-badge">!</span>
                        <h5 class="title"><?php echo e(__("Preview")); ?></h5>
                    </div>
                    <div class="dash-payment-body">
                        <div class="preview-list-wrapper">
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-plug"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Bill Pay")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="bill-type">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-list-ol"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Bill Month")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="bill-month">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-list-ol"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Bill Number")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="bill-number">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-hand-holding-usd"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Amount")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="request-amount">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-exchange-alt"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Exchange Rate")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="rate-show">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-hand-holding-usd"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Conversion Amount")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="text--info conversion-amount">--</span>
                                </div>
                            </div>
                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-hand-holding-usd"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Total Charge")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="fees">--</span>
                                </div>
                            </div>

                            <div class="preview-list-item">
                                <div class="preview-list-left">
                                    <div class="preview-list-user-wrapper">
                                        <div class="preview-list-user-icon">
                                            <i class="las la-hand-holding-usd"></i>
                                        </div>
                                        <div class="preview-list-user-content">
                                            <span><?php echo e(__("Total Payable")); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-list-right">
                                    <span class="text--base last payable-total">--</span>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="dashboard-list-area mt-20">
        <div class="dashboard-header-wrapper">
            <h4 class="title "><?php echo e(__("Bill Pay Log")); ?></h4>
            <div class="dashboard-btn-wrapper">
                <div class="dashboard-btn mb-2">
                    <a href="<?php echo e(setRoute('agent.transactions.index','bill-pay')); ?>" class="btn--base"><?php echo e(__("View More")); ?></a>
                </div>
            </div>
        </div>
        <div class="dashboard-list-wrapper">
            <?php echo $__env->make('agent.components.transaction-log',compact("transactions"), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<script>
    var defualCurrency = "<?php echo e(get_default_currency_code()); ?>";
    var defualCurrencyRate = "<?php echo e(get_default_currency_rate()); ?>";

    $(document).ready(function(){
        senderBalance();
        getLimit();
        getExchangeRate();
        getFees();
        activeItems();
    });
    $("input[name=amount]").keyup(function(){
        getFees();
        getLimit();
        activeItems();
    });
    $("input[name=amount]").focusout(function(){
        var limit_validate = enterLimit();
        if(limit_validate.type == 'min'){
            throwMessage('error',[limit_validate.message]);
            $('.billPayBtn').attr('disabled',true)
        }else if(limit_validate.type == 'max'){
            throwMessage('error',[limit_validate.message]);
            $('.billPayBtn').attr('disabled',true)
        }
    });
    $("input[name=bill_number]").keyup(function(){
        getFees();
        getLimit();
        activeItems();
    });
    $("select[name=bill_type]").change(function(){
        getFees();
        getLimit();
        getExchangeRate();
        activeItems();
    });
    $("select[name=bill_month]").change(function(){
        getFees();
        getLimit();
        getExchangeRate();

        activeItems();
    });

    $("select[name=currency]").change(function(){
        senderBalance();
        getFees();
        getExchangeRate();
        getLimit();

    });

    function getLimit() {
        var exchangeRate =  parseFloat($("input[name=exchange_rate]").val());
        var walletCurrencyCode = acceptVar().SCurrencyCode;
        if(acceptVar().billType.val() === "null"){
            return false;
        }
        if(acceptVar().billType.data('item-type') === "AUTOMATIC"){
            var item = acceptVar().billType.data('item');
            var min_limit = parseFloat(item.minLocalTransactionAmount) / parseFloat(exchangeRate);
            var max_limit = parseFloat(item.maxLocalTransactionAmount) / parseFloat(exchangeRate);
            $('.limit-show').html("<?php echo e(__('limit')); ?> " + min_limit.toFixed(4) + " " + walletCurrencyCode + " - " + max_limit.toFixed(4) + " " + walletCurrencyCode);
        }else{
            var currencyCode = acceptVar().SCurrencyCode;
            var currencyRate = acceptVar().SCurrencyRate;

            var min_limit = acceptVar().currencyMinAmount;
            var max_limit =acceptVar().currencyMaxAmount;
            if($.isNumeric(min_limit) || $.isNumeric(max_limit)) {
                var min_limit_calc = parseFloat(min_limit/exchangeRate).toFixed(4);
                var max_limit_clac = parseFloat(max_limit/exchangeRate).toFixed(4);
                $('.limit-show').html("<?php echo e(__('limit')); ?> " + min_limit_calc + " " + currencyCode + " - " + max_limit_clac + " " + currencyCode);

                return {
                    minLimit:min_limit_calc,
                    maxLimit:max_limit_clac,
                };
            }else {
                $('.limit-show').html("--");
                return {
                    minLimit:0,
                    maxLimit:0,
                };
            }

        }

    }
    function getExchangeRate() {
        var walletCurrencyCode = acceptVar().SCurrencyCode;
        var walletCurrencyRate = acceptVar().SCurrencyRate;
        var sender_amount = $("input[name=amount]").val();

        sender_amount == "" ? (sender_amount = 0) : (sender_amount = sender_amount);

        if (acceptVar().billType.data('item-type') === "AUTOMATIC") {
                var item = acceptVar().billType.data('item');
                var receiver_currency_code = item.localTransactionCurrencyCode;
        } else {
            var receiver_currency_code = acceptVar().defaultCurrencyCode;
        }
        $.ajax({
        type:'get',
            url:"<?php echo e(route('global.receiver.wallet.currency')); ?>",
            data:{code:receiver_currency_code},
            success:function(data){
                var receiverCurrencyCode = data.code;
                var receiverCurrencyRate = data.rate;
                var exchangeRate = (receiverCurrencyRate/walletCurrencyRate);

                $("input[name=exchange_rate]").val(exchangeRate);
                $('.rate-show').html("1 " +walletCurrencyCode+ " = " + parseFloat(exchangeRate).toFixed(8) + " " + receiverCurrencyCode);
                feesCalculation();
                getFees();
                getLimit();
                enterLimit();
                activeItems();
            }
        });
    }
    function acceptVar() {
        var senderCurrSelectedVal = $("select[name=currency] :selected");
        var senderCurrencyCode = $("select[name=currency] :selected").val();
        var senderCurrencyRate = $("select[name=currency] :selected").data('rate');

        var defaultCurrencyCode = defualCurrency;
        var defaultCurrencyRate = defualCurrencyRate;

        var currencyMinAmount ="<?php echo e(getAmount($billPayCharge->min_limit)); ?>";
        var currencyMaxAmount = "<?php echo e(getAmount($billPayCharge->max_limit)); ?>";

        var currencyFixedCharge = "<?php echo e(getAmount($billPayCharge->fixed_charge)); ?>";
        var currencyPercentCharge = "<?php echo e(getAmount($billPayCharge->percent_charge)); ?>";

        var billType = $("select[name=bill_type] :selected");
        var billName = $("select[name=bill_type] :selected").data("name");
        var billMonth = $("select[name=bill_month] :selected").val();
        var billNumber = $("input[name=bill_number]").val();

        return {
            sCurrSelectedVal:senderCurrSelectedVal,
            SCurrencyCode:senderCurrencyCode,
            SCurrencyRate:senderCurrencyRate,

            defaultCurrencyCode:defaultCurrencyCode,
            defaultCurrencyRate:defaultCurrencyRate,

            currencyMinAmount:currencyMinAmount,
            currencyMaxAmount:currencyMaxAmount,

            currencyFixedCharge:currencyFixedCharge,
            currencyPercentCharge:currencyPercentCharge,

            billName:billName,
            billNumber:billNumber,
            billMonth:billMonth,
            billType:billType,


        };
    }
    function feesCalculation() {
        var exchangeRate =  parseFloat($("input[name=exchange_rate]").val());
        var currencyCode = acceptVar().SCurrencyCode;
        var currencyRate = acceptVar().SCurrencyRate;
        var sender_amount = $("input[name=amount]").val();
        sender_amount == "" ? (sender_amount = 0) : (sender_amount = sender_amount);

        var fixed_charge = acceptVar().currencyFixedCharge;
        var percent_charge = acceptVar().currencyPercentCharge;
        if ($.isNumeric(percent_charge) && $.isNumeric(fixed_charge) && $.isNumeric(sender_amount)) {
            // Process Calculation
            var fixed_charge_calc = parseFloat(fixed_charge/exchangeRate);
            var percent_charge_calc = (parseFloat(sender_amount) / 100) * parseFloat(percent_charge);
            var total_charge = parseFloat(fixed_charge_calc) + parseFloat(percent_charge_calc);
            total_charge = parseFloat(total_charge).toFixed(4);
            // return total_charge;
            return {
                total: total_charge,
                fixed: fixed_charge_calc,
                percent: percent_charge,
            };
        } else {
            // return "--";
            return false;
        }
    }
    function getFees() {
        var currencyCode = acceptVar().SCurrencyCode;
        var exchangeRate =  parseFloat($("input[name=exchange_rate]").val());
        if(acceptVar().billType.val() === "null"){
            return false;
        }
        if(acceptVar().billType.data('item-type') === "AUTOMATIC"){
            var item = acceptVar().billType.data('item');
            var fixed_charge  = parseFloat(item.localTransactionFee) / parseFloat(exchangeRate);
            var percent_charge  = parseFloat(item.localTransactionFeePercentage);
            $(".fees-show").html("<?php echo e(__('Bill Pay Charges')); ?>: " + fixed_charge.toFixed(4) + " " + currencyCode + " + " + percent_charge + "%  ");
        }else{
            var percent = acceptVar().currencyPercentCharge;
            var charges = feesCalculation();
            if (charges == false) {
                    return false;
            }
            $(".fees-show").html("<?php echo e(__('Bill Pay Charges')); ?>: " + parseFloat(charges.fixed).toFixed(4) + " " + currencyCode + " + " + parseFloat(charges.percent).toFixed(4) + "%  ");
        }

    }
    function activeItems(){
        var billType = acceptVar().billType.val();
        if(billType === undefined || billType === '' || billType === null){
            return false;
        }else{
            return getPreview();
        }
    }
    function getPreview() {
        if(acceptVar().billType.val() === "null"){
            return false;
        }
        var senderAmount = $("input[name=amount]").val();
        var wallet_currency = acceptVar().SCurrencyCode;
        var billName = acceptVar().billName;
        var billNumber = acceptVar().billNumber;
        var exchangeRate =  parseFloat($("input[name=exchange_rate]").val());
        senderAmount == "" ? senderAmount = 0 : senderAmount = senderAmount;
        var conversion_amount = parseFloat(senderAmount).toFixed(8) * parseFloat(exchangeRate).toFixed(8);
        //fillup hidden fields
        $("input[name=biller_item_type]").val(acceptVar().billType.data('item-type'));
        //fillup hidden fields

        if (acceptVar().billType.data('item-type') === "AUTOMATIC") {
            var item = acceptVar().billType.data('item');
            var rCurrencyCode = item.localTransactionCurrencyCode;
            var fixed_charge  = parseFloat(item.localTransactionFee) / parseFloat(exchangeRate);
            var percent_charge  = parseFloat(item.localTransactionFeePercentage);
            var final_charge = fixed_charge + percent_charge;
        } else {
            var rCurrencyCode = acceptVar().defaultCurrencyCode;
            var charges = feesCalculation();
            var final_charge = charges.total;
        }

        // Sending Amount
        $('.request-amount').text(parseFloat(senderAmount).toFixed(4) + " " + wallet_currency);
        $('.conversion-amount').text(parseFloat(conversion_amount).toFixed(4) + " " + rCurrencyCode);
        //bill type
        $('.bill-type').text(billName);
        $('.bill-month').text(acceptVar().billMonth);
        // Fees
        //bill number
        if(billNumber == '' || billNumber == 0){
            $('.bill-number').text("Ex: 1234567891");
        }else{
            $('.bill-number').text(billNumber);
        }
        // Fees
        var total_charge = 0;
        if(senderAmount == 0){
            total_charge = 0;
        }else{
            total_charge = final_charge;
        }

        $('.fees').text(parseFloat(total_charge).toFixed(4) + " " + wallet_currency);
        // Pay In Total
        var totalPay = parseFloat(senderAmount) + parseFloat(total_charge)
        var pay_in_total = 0;
        if(senderAmount == 0){
            pay_in_total = 0;
        }else{
            pay_in_total =  parseFloat(totalPay);
        }
        $('.payable-total').text(parseFloat(pay_in_total).toFixed(4) + " " + wallet_currency);

    }

    function enterLimit(){
        var exchangeRate =  parseFloat($("input[name=exchange_rate]").val());
        var sender_amount = parseFloat($("input[name=amount]").val());

        if (acceptVar().billType.data('item-type') === "AUTOMATIC") {
            var item = acceptVar().billType.data('item');
            var min_limit =( parseFloat(item.minLocalTransactionAmount) / parseFloat(exchangeRate));
            var max_limit = (parseFloat(item.maxLocalTransactionAmount)/ parseFloat(exchangeRate));

        } else {
            var min_limit = parseFloat(acceptVar().currencyMinAmount/exchangeRate);
            var max_limit = parseFloat(acceptVar().currencyMaxAmount/exchangeRate);

        }
       // Corrected code:
        if (sender_amount === "NaN" || sender_amount === "") {
            sender_amount = 0;
        }
        if( sender_amount < min_limit ){
            return{
                message: '<?php echo e(__("Please follow the mimimum limit")); ?>',
                type   : 'min'
            }
        }else if(sender_amount > max_limit){
            return{
                message: '<?php echo e(__("Please follow the maximum limit")); ?>',
                type   : 'max'
            }
        }else{
            $('.billPayBtn').attr('disabled',false);
            return{
                message: 'success',
                type   : 'success'
            }
        }

    }
    function senderBalance(){
        var senderCurrency = acceptVar().SCurrencyCode;
        var csrfToken = $('meta[name="csrf-token"]').attr('content');
        $.ajax({
            type: 'POST',
            url: "<?php echo e(route('agent.wallets.balance')); ?>",
            data: {
                target: senderCurrency,
                _token: csrfToken
            },
            success: function(response) {
                $('.balance-show').html("<?php echo e(__('Available Balance')); ?>: " + parseFloat(response.data).toFixed(2) + " " + senderCurrency);
            }
        });
    }
</script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('agent.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp-8.0.2\htdocs\qrpay\v4.5.0\multiple\resources\views/agent/sections/bill-pay/index.blade.php ENDPATH**/ ?>