@extends('admin.layouts.master')

@push('css')
    <style>
        .fileholder {
            min-height: 300px !important;
        }

        .fileholder-files-view-wrp.accept-single-file .fileholder-single-file-view,.fileholder-files-view-wrp.fileholder-perview-single .fileholder-single-file-view{
            height: 256px !important;
        }
    </style>
@endpush

@section('page-title')
    @include('admin.components.page-title',['title' => __($page_title)])
@endsection

@section('breadcrumb')
    @include('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ]
    ], 'active' => __($page_title)])
@endsection

@section('content')
    <form action="{{ setRoute('admin.remitance.bank.deposit.update') }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method("PUT")
        <input type="hidden" name="target" value="{{ $bank->id }}">
        @include('admin.components.bank.manual.edit-header',['title' => $page_title,'bank' => $bank])
        <div class="custom-card mt-15">
            <div class="card-body">
                <div class="row">
                    @include('admin.components.bank.manual.edit-charges')
                </div>
                <div class="row mb-10-none">
                    <div class="col-xl-12 col-lg-12 form-group">
                        @include('admin.components.button.form-btn',[
                            'class'         => "w-100 btn-loading",
                            'text'          => __("update"),
                            'permission'    => "admin.remitance.bank.deposit.update",
                        ])
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection

@push('script')

@endpush
