@extends('admin.layouts.master')

@push('css')

@endpush

@section('page-title')
    @include('admin.components.page-title',['title' => __($page_title)])
@endsection

@section('breadcrumb')
    @include('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ]
    ], 'active' => __("User Account Data")])
@endsection

@section('content')
    <div class="row justify-content-center">
        <div class="col-lg-8">HELLO
            <div class="card b-radius--10">
                <div class="card-body">
                    @if ($data->accountDATA)
						@php
							$arr=(array)json_decode($data->accountDATA,true);
							//dd($arr);
						@endphp
                        <ul class="list-group">
						 @foreach ($arr as $key => $val)
							
							{{-- @continue(!$val->value) --}}
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                   {{ __($key) }}
                                    <span>
									@if(is_array($val))
										{{-- route('admin.bankaccount.download.attachment', encrypt('https://localhost/1simple-QRPAY'. '' . $val['path'])) --}}
										<a href="{{'https://localhost/1simple-QRPAY'. '' . $val['path']}}"><i class="fa fa-file"></i> @lang($val['filename'].' File Attachment') </a>										
									@else									
    									@if(trim($key)=='Time')
    									{{date('m/d/Y', $val);}}
    									@else
    										{{ $val }}
    									@endif	
									@endif
										{{--       @if ($val->type == 'checkbox')
                                            {{ implode(',', $val->value) }}
                                        @elseif($val->type == 'file')
                                            @if ($val->value)
                                                @can('admin.download.attachment')
                                                    <a href="{{ route('admin.download.attachment', encrypt(getFilePath('verify') . '/' . $val->value)) }}"><i class="fa fa-file"></i> @lang('Attachment') </a>
                                                @endcan
                                            @else
                                                @lang('No File')
                                            @endif
                                        @else
                                            <p>{{ __($val->value) }}</p>
                                        @endif --}}
                                    </span>
                                </li>
                            @endforeach
                        </ul>
                    @else
                        <h5 class="text-center">@lang(' data not found')</h5>
                    @endif

									@if(Auth::user()->id==2)		
                        <div class="d-flex justify-content-end mt-3 flex-wrap">
                    
                                <button class="btn--base btn-outline--danger me-3 confirmationBtn" data-question="@lang('Are you sure to reject this documents?')" data-action="{{ route('admin.bankaccount.bac.reject', $data->accountId) }}"><i class="las la-ban"></i>@lang('Reject')</button>
                    
                    
                                <button class="btn--base btn-outline--success confirmationBtn" data-question="@lang('Are you sure to approve this documents?')" data-action="{{ route('admin.bankaccount.bac.approve', $data->accountId) }}"><i class="las la-check"></i>@lang('Approve')</button>
                            
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

@props(['height' => ''])
<div class="modal fade" id="confirmationModal" role="dialog" tabindex="-1">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">@lang('Confirmation Alert!')</h5>
                <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="" method="POST">
                @csrf
                <div class="modal-body">
                    <p class="question"></p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn--dark btn-sm" data-bs-dismiss="modal" type="button">@lang('No')</button>
                    <button class="btn btn--primary btn-sm {{ $height }}" type="submit">@lang('Yes')</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('script')
    <script>
        (function($) {
            "use strict";
            $(document).on('click', '.confirmationBtn', function() {
                var modal = $('#confirmationModal');
                let data = $(this).data();
                modal.find('.question').text(`${data.question}`);
                modal.find('form').attr('action', `${data.action}`);
                modal.modal('show');
            });
        })(jQuery);
    </script>
@endpush

