<div class="custom-card">
    <div class="card-header">
        <h6 class="title">
            <?php if(isset($title)): ?>
                <?php echo e(__($title)); ?>

            <?php endif; ?>
        </h6>
    </div>
    <div class="card-body">
        <div class="row mb-10-none">
            <div class="col-xl-3 col-lg-3 form-group">
                <?php echo $__env->make('admin.components.form.input-file',[
                    'label'             => __("Bank Image"),
                    'class'             => "file-holder",
                    'name'              => "image",
                    'old_files_path'    => files_asset_path('bank-images'),
                    'old_files'         => $bank->image,
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-xl-9 col-lg-9">
                <div class="form-group">
                    <?php echo $__env->make('admin.components.form.input',[
                        'label'         => __("bank Name")."*",
                        'name'          => "name",
                        'placeholder'   => __("ex").": United Bank Limited",
                        'value'         => @$bank->name,
                        'data_limit'    => 60,
                        'attribute'     => "required",
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="form-group">
                    <?php echo $__env->make('admin.components.form.input',[
                        'label'         => __("Currency Name*"),
                        'name'          => "currency_name",
                        'placeholder'   => __("ex").": United State Dollar",
                        'value'         => @$bank->currency_name,
                        'data_limit'    => 60,
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="form-group">
                    <?php echo $__env->make('admin.components.form.input',[
                    'label'     =>__( "Currency Code")."*",
                        'name'          => "code",
                        'placeholder'   => __("ex").": USD",
                        'value'         => @$bank->code,
                        'class'         => "currency_type",
                        'data_limit'    => 8,
                        'attribute'     => "required",
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="form-group">
                    <?php echo $__env->make('admin.components.form.input',[
                       'label'     =>__( "Currency Symbol")."*",
                        'name'          => "currency_symbol",
                        'placeholder'   => __("ex").": $",
                        'value'         => $bank->currency_symbol,
                        'data_limit'    => 10,
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/admin/components/bank/manual/edit-header.blade.php ENDPATH**/ ?>