

<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title', ['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __('User Care'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="table-area">
        <div class="table-wrapper">
            <div class="table-header">
                <h5 class="title"><?php echo e($page_title); ?></h5>
            </div>
            <div class="table-responsive">
                <div class="table-area">
                    <div class="table-wrapper">
                        <div class="table-header">
                            <h5 class="title"><?php echo e(__("User Email Logs")); ?></h5>
                        </div>
                        <div class="table-responsive">
                            <table class="custom-table">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th><?php echo e(__("USER")); ?></th>
                                        <th><?php echo e(__("send")); ?></th>
                                        <th><?php echo e(__("Mail Sender(Method)")); ?></th>
                                        <th><?php echo e(__("Subject")); ?></th>
                                        <th><?php echo e(__("Message")); ?></th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td>
                                                <ul class="user-list">
                                                    <li><img src="<?php echo e($item->user->userImage); ?>" alt="user"></li>
                                                </ul>
                                            </td>
                                            <td><?php echo e($item->user->username); ?></td>
                                            <td><?php echo e($item->created_at->format("Y-m-d H:i")); ?></td>
                                            <td><?php echo e($item->method ?? "SMTP"); ?></td>
                                            <td><?php echo e($item->subject); ?></td>
                                            <td title="<?php echo e(strip_tags($item->message)); ?>"><?php echo e(Str::words(strip_tags($item->message), 5, '...')); ?></td>
                                            <td>
                                                <a href="<?php echo e(setRoute('admin.users.details',$item->user->username)); ?>" class="btn btn--base"><i class="las la-info-circle"></i></a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <?php echo $__env->make('admin.components.alerts.empty',['colspan' => 7], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo e(get_paginate($logs)); ?>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/admin/sections/user-care/mail-logs.blade.php ENDPATH**/ ?>