<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title', ['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __('User Care'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="custom-card">
        <div class="card-header">
            <h6 class="title"><?php echo e(__("Email To Users")); ?></h6>
        </div>
        <div class="card-body">
            <form class="card-form" action="<?php echo e(setRoute('admin.users.email.users.send')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="row mb-10-none">
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label><?php echo e(__("User")); ?>*</label>
                        <select class="form--control nice-select" name="user_type">
                            <option selected disabled><?php echo e(__("Select Users")); ?></option>
                            <option value="all"><?php echo e(__("All Users")); ?></option>
                            <option value="active"><?php echo e(__("Active Users")); ?></option>
                            <option value="email_unverified"><?php echo e(__("Email Unverified")); ?></option>
                            <option value="kyc_unverified"><?php echo e(__("Kyc Unverified")); ?></option>
                            <option value="banned"><?php echo e(__("Banned Users")); ?></option>
                        </select>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input',[
                            'label'         => __("Subject")."*",
                            'name'          => 'subject',
                            'value'         => old('subject'),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        <?php echo $__env->make('admin.components.form.input-text-rich',[
                             'label'         => __("Details")."*",
                            'name'          => 'message',
                            'value'         => old('message'),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        <?php echo $__env->make('admin.components.button.form-btn',[
                            'class'         => "w-100 btn-loading",
                            'permission'    => "admin.users.email.users.send",
                            'text'          => __("Send Email"),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/admin/sections/user-care/email-to-users.blade.php ENDPATH**/ ?>