<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title', ['title' => __("Remittance Details")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __('Remittance Details'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="custom-card">
    <div class="card-header">
        <h6 class="title"><?php echo e(__($page_title)); ?></h6>
    </div>
    <div class="card-body">
        <form class="card-form">
            <div class="row align-items-center mb-10-none">
                <div class="col-xl-4 col-lg-4 form-group">
                    <ul class="user-profile-list-two">
                        <li class="one"><?php echo e(__("Date")); ?>: <span><?php echo e(@$data->created_at->format('d-m-y h:i:s A')); ?></span></li>
                        <?php if( @$data->details->remitance_type == "bank-transfer"): ?>
                        <li class="two"><?php echo e(__("account Number")); ?>:
                            <span class="text-base"> <?php echo e(ucwords(str_replace('-', ' ', @$data->details->bank_account))); ?></span>
                        </li>
                        <?php else: ?>
                        <li class="two"><?php echo e(__("web_trx_id")); ?>: <span><?php echo e(@$data->trx_id); ?></span></li>
                        <?php endif; ?>
                        <li class="three"><?php echo e(__("sender")); ?>:
                            <?php if($data->attribute == "SEND"): ?>
                                <?php if($data->user_id != null): ?>
                                <a href="<?php echo e(setRoute('admin.users.details',$data->user->username)); ?>"><?php echo e($data->user->fullname); ?> <?php echo e("(USER)"); ?></a>
                                <?php elseif($data->agent_id != null): ?>
                                <a href="<?php echo e(setRoute('admin.agents.details',$data->creator->username)); ?>"><?php echo e($data->creator->fullname); ?> <?php echo e("(AGENT)"); ?></a>
                                <?php elseif($data->merchant_id != null): ?>
                                <a href="<?php echo e(setRoute('admin.merchants.details',$data->creator->username)); ?>"><?php echo e($data->creator->fullname); ?> <?php echo e(("MERCHANT")); ?></a>
                                <?php endif; ?>
                            <?php else: ?>
                            <span><?php echo e($data->details->sender->fullname); ?> (<?php echo e(@$data->user->full_mobile); ?>)</span>
                            <?php endif; ?>
                        </li>
                        <li class="four"><?php echo e(__("Receiver")); ?>:
                            <?php if($data->attribute == "RECEIVED"): ?>
                                <?php if($data->user_id != null): ?>
                                <a href="<?php echo e(setRoute('admin.users.details',$data->user->username)); ?>"><?php echo e($data->user->fullname); ?></a>
                                <?php elseif($data->agent_id != null): ?>
                                    <a href="<?php echo e(setRoute('admin.agents.details',$data->creator->username)); ?>"><?php echo e($data->creator->fullname); ?></a>
                                <?php elseif($data->merchant_id != null): ?>
                                    <a href="<?php echo e(setRoute('admin.merchants.details',$data->creator->username)); ?>"><?php echo e($data->creator->fullname); ?></a>
                                <?php endif; ?>
                            <?php else: ?>
                                <?php if($data->user_id != null): ?>
                                    <span><?php echo e(@$data->details->receiver->firstname); ?> <?php echo e(@$data->details->receiver->lastname); ?></span>
                                <?php elseif($data->agent_id != null): ?>
                                    <span><?php echo e(@$data->details->receiver_recipient->firstname); ?> <?php echo e(@$data->details->receiver_recipient->lastname); ?></span>
                                <?php endif; ?>
                            <?php endif; ?>
                        </li>
                        <li class="five"><?php echo e(__("sending Country")); ?>: <span class="fw-bold"><?php echo e(@$data->details->form_country); ?></span></li>
                        <li class="five"><?php echo e(__("Receiving Country")); ?>: <span class="fw-bold"><?php echo e(@$data->details->to_country->country); ?></span></li>
                        <li class="one"><?php echo e(__("Remittance Type")); ?>:
                            <?php if( @$data->details->remitance_type == "wallet-to-wallet-transfer"): ?>
                                <span class="fw-bold"> <?php echo e(@$basic_settings->site_name); ?> <?php echo e(__("Wallet")); ?> </span>
                                <?php else: ?>
                                <span class="fw-bold"> <?php echo e(ucwords(str_replace('-', ' ', @$data->details->remitance_type))); ?> </span>

                            <?php endif; ?>

                            </li>

                        <li class="two"><?php echo e(__("Payment Referance")); ?>:
							<?php echo e(@$data->details->payment_referance); ?>

                        </li>



                    </ul>
                </div>

                <div class="col-xl-4 col-lg-4 form-group">
                    <div class="user-profile-thumb">
                        <?php if($data->user_id != null): ?>
                            <img src="<?php echo e(@$data->user->userImage); ?>" alt="payment">
                        <?php elseif($data->agent_id != null): ?>
                            <img src="<?php echo e(@$data->agent->agentImage); ?>" alt="payment">
                        <?php endif; ?>

                    </div>
                </div>
                <div class="col-xl-4 col-lg-4 form-group">
                    <ul class="user-profile-list two">
                        <?php
                        if ($data->user_id != null) {
                            $alias = @$data->details->receiver->alias;
                        }elseif($data->agent_id != null){
                            $alias = @$data->details->receiver_recipient->alias;
                        }
                        ?>

                        <?php if( @$data->details->remitance_type == "bank-transfer"): ?>
                        <li class="one"><?php echo e(__("bank Name")); ?>:
                            <span class="text-base"> <?php echo e(ucwords(str_replace('-', ' ', @$alias))); ?></span>
                        </li>

                        <?php endif; ?>
                        <?php if( @$data->details->remitance_type == "cash-pickup"): ?>
                        <li class="one"><?php echo e(__("Pickup Point")); ?>:
                            <span class="text-base"> <?php echo e(ucwords(str_replace('-', ' ', @$alias))); ?></span>
                        </li>
                        <?php endif; ?>
                        <li class="three"><?php echo e(__("Exchange Rate")); ?>:
                            <span>
                                1 <?php echo e($data->details->charges->sender_cur_code??get_default_currency_code()); ?> = <?php echo e(get_amount($data->details->charges->exchange_rate??$data->details->to_country->rate,$data->details->to_country->code)); ?>

                            </span>
                        </li>
                        <li class="four"><?php echo e(__("Send Amount")); ?>: <span><?php echo e(get_amount($data->request_amount,$data->details->charges->sender_cur_code??get_default_currency_code())); ?></span></li>
                        <li class="two"><?php echo e(__("Charge")); ?>: <span><?php echo e(get_amount($data->charge->total_charge,$data->details->charges->sender_cur_code??get_default_currency_code())); ?></span></li>
                        <li class="three"><?php echo e(__("Payable Amount")); ?>: <span><?php echo e(get_amount($data->payable,$data->details->charges->sender_cur_code??get_default_currency_code())); ?></span></li>
                        <li class="three"><?php echo e(__("Receipient Get")); ?>: <span><?php echo e(get_amount($data->details->recipient_amount,$data->details->to_country->code)); ?></span></li>
                        <li class="four"><?php echo e(__("Status")); ?>:  <span class="<?php echo e(@$data->stringStatus->class); ?>"><?php echo e(__(@$data->stringStatus->value)); ?></span></li>
                        <li class="one"><?php echo e(__("Invoice / Documents")); ?>:
							
							<a href="<?php echo e(route('admin.remitance.download.attachment', encrypt( @$data->details->{'Invoice / Documents'}->path))); ?>" >
								<?php echo e(@$data->details->{'Invoice / Documents'}->filename); ?>

								
							</a>							
                        </li>						
                    </ul>
                </div>
            </div>
        </form>
    </div>
</div>

<?php if(@$data->status == 2): ?>
<div class="custom-card mt-15">
    <div class="card-body">
        <div class="product-sales-btn">
            <button type="button" class="btn btn--base approvedBtn"><?php echo e(__("approve")); ?></button>
            <button type="button" class="btn btn--danger rejectBtn" ><?php echo e(__("reject")); ?></button>
        </div>
    </div>
</div>

<div class="modal fade" id="approvedModal" tabindex="-1" >
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header p-3" id="approvedModalLabel">
                <h5 class="modal-title"><?php echo e(__("Approved Confirmation")); ?> ( <span class="fw-bold text-danger"><?php echo e(number_format(@$data->request_amount,2)); ?> <?php echo e(get_default_currency_code()); ?></span> )</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form class="modal-form" action="<?php echo e(setRoute('admin.remitance.approved')); ?>" method="POST">

                    <?php echo csrf_field(); ?>
                    <?php echo method_field("PUT"); ?>
                    <div class="row mb-10-none">
                        <div class="col-xl-12 col-lg-12 form-group">
                            <input type="hidden" name="id" value=<?php echo e(@$data->id); ?>>
                           <p><?php echo e(__("Are you sure to approved this request?")); ?></p>
                        </div>
                    </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn--danger" data-bs-dismiss="modal"><?php echo e(__("Cancel")); ?></button>
                <button type="submit" class="btn btn--base btn-loading "><?php echo e(__("Approved")); ?></button>
            </div>
        </form>
        </div>
    </div>
</div>
<div class="modal fade" id="rejectModal" tabindex="-1" >
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header p-3" id="rejectModalLabel">
                <h5 class="modal-title"><?php echo e(__("Rejection Confirmation")); ?> ( <span class="fw-bold text-danger"><?php echo e(number_format(@$data->request_amount,2)); ?> <?php echo e(get_default_currency_code()); ?></span> )</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form class="modal-form" action="<?php echo e(setRoute('admin.remitance.rejected')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field("PUT"); ?>
                    <div class="row mb-10-none">
                        <div class="col-xl-12 col-lg-12 form-group">
                            <input type="hidden" name="id" value=<?php echo e(@$data->id); ?>>
                            <?php echo $__env->make('admin.components.form.textarea',[
                                'label'         => __("Explain Rejection Reason*"),
                                'name'          => 'reject_reason',
                                'value'         => old('reject_reason')
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn--danger" data-bs-dismiss="modal"><?php echo e(__("Cancel")); ?></button>
                <button type="submit" class="btn btn--base"><?php echo e(__("confirm")); ?></button>
            </div>
        </form>
        </div>
    </div>
</div>
<?php endif; ?>


<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
<script>
    $(document).ready(function(){
        <?php if($errors->any()): ?>
        var modal = $('#rejectModal');
        modal.modal('show');
        <?php endif; ?>
    });
</script>
<script>
     (function ($) {
        "use strict";
        $('.approvedBtn').on('click', function () {
            var modal = $('#approvedModal');
            modal.modal('show');
        });
        $('.rejectBtn').on('click', function () {
            var modal = $('#rejectModal');
            modal.modal('show');
        });
    })(jQuery);





</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/surgepay/public_html/surgeqrpay/resources/views/admin/sections/remitance/details.blade.php ENDPATH**/ ?>