<?php
    $type = App\Constants\GlobalConst::SETUP_PAGE;
    $menues = DB::table('setup_pages')
            ->where('status', 1)
            ->where('type', Str::slug($type))
            ->get();
?>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start Header
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<header class="header-section home">
    <div class="header">
        <div class="header-bottom-area">
            <div class="container">
                <div class="header-menu-content">
                    <nav class="navbar navbar-expand-lg p-0">
                        <a class="site-logo site-title" href="<?php echo e(setRoute('index')); ?>">
                            <img src="<?php echo e(get_logo($basic_settings)); ?>"  data-white_img="<?php echo e(get_logo($basic_settings,'white')); ?>"
                            data-dark_img="<?php echo e(get_logo($basic_settings,'dark')); ?>"
                                alt="site-logo">
                        </a>
                        <button class="navbar-toggler ms-auto" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"
                            aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                            <span class="fas fa-bars"></span>
                        </button>
                        <div class="collapse navbar-collapse" id="navbarSupportedContent">
                            <ul class="navbar-nav main-menu ms-auto me-auto">
                            <?php
                                $current_url = URL::current();
                            ?>
                            <?php $__currentLoopData = $menues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $title = json_decode($item->title);
                                ?>
                                <li><a href="<?php echo e(url($item->url)); ?>" class="<?php if($current_url == url($item->url)): ?> active <?php endif; ?>"><span><?php echo e(__($title->title)); ?></span></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>

                            <div class="header-action">
                                <div class="lang-select">
                                    <?php
                                    $session_lan = session('local')??get_default_language_code();
                                    ?>
                                    <select class="form--control langSel nice-select">
                                        <?php $__currentLoopData = $__languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($item->code); ?>" <?php if( $session_lan == $item->code): ?> selected  <?php endif; ?>><?php echo e(__($item->name)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                               <?php if(auth()->guard()->check()): ?>
                               <a href="<?php echo e(setRoute('user.dashboard')); ?>" class="btn--base"><i class="las la-user-edit me-2"></i></i><?php echo e(__("Dashboard")); ?></a>
                               <?php else: ?>
                               <a href="<?php echo e(setRoute('user.login')); ?>" class="btn--base"><i class="las la-user-edit me-2"></i></i><?php echo e(__("Login Now")); ?></a>
                               <?php endif; ?>
                            </div>
                        </div>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</header>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End Header
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<?php /**PATH E:\xampp 8.0.2\htdocs\simple-pay\resources\views/frontend/partials/header.blade.php ENDPATH**/ ?>