<?php
    $lang = selectedLang();
    $choose_slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::CHOOSE_SECTION);
    $choose = App\Models\Admin\SiteSections::getData( $choose_slug)->first();
?>
<section class="choose-us-section pt-120">
    <div class="container">
        <div class="choose-us-main-wrapper">
            <div class="row justify-content-center">
                <div class="col-xl-7 text-center">
                    <div class="section-header">
                        <span class="section-sub-titel"><i class="fas fa-qrcode"></i><?php echo e(__(@$choose->value->language->$lang->heading)); ?></span>
                        <h2 class="section-title"><?php echo e(__(@$choose->value->language->$lang->sub_heading)); ?></h2>
                        <p><?php echo e(__(@$choose->value->language->$lang->details)); ?></p>
                    </div>
                </div>
                <div class="row mb-60-none justify-content-center">
                <?php if(isset($choose->value->items)): ?>
                <?php
                    $num = 0;
                ?>
                    <?php $__currentLoopData = $choose->value->items ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $num += 1;
                    ?>
                    <div class="col-lg-4 col-md-6 mb-60">
                        <div class="choose-us-item">
                            <div class="icon-wrapper">
                                <div class="icon-area">
                                    <i class="<?php echo e(__( @$item->language->$lang->icon)); ?>"></i>
                                    <span class="choose-badge"><?php echo e('0'.@$num); ?></span>
                                </div>
                            </div>
                            <h3 class="title"><?php echo e(__( @$item->language->$lang->title)); ?></h3>
                            <p><?php echo e(__( @$item->language->$lang->sub_title)); ?></p>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH E:\xampp-8.0.2\htdocs\qrpay\v4.5.0\full_project\resources\views/frontend/partials/choose-section.blade.php ENDPATH**/ ?>