<?php

namespace App\Http\Controllers\Admin;

use App\Constants\GlobalConst;
use App\Http\Controllers\Controller;
use App\Http\Helpers\Response;
use App\Models\Admin\GroupHasAgent;
use App\Models\Admin\GroupHasMerchant;
use App\Models\Admin\GroupHasTransactionCharge;
use App\Models\Admin\GroupHasUser;
use App\Models\Admin\SetupUserGroup;
use App\Models\Admin\TransactionSetting;
use App\Models\Agent;
use App\Models\Merchants\Merchant;
use App\Models\User;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class SetupUserGroupController extends Controller
{
    //==========================================User Group Setup============================================
        public function userGroups(){
            $page_title = __("Setup Group");
            $allGroups = SetupUserGroup::user()->paginate(10);
            return view('admin.sections.setup-group.user.index',compact(
                'page_title',
                'allGroups',
            ));

        }
        public function createUserGroup(){
            $page_title = __("Create Group");
            $transaction_charges = TransactionSetting::where('type',GlobalConst::USER)->get();
            $allUsers = User::active()->get();
            $assignedGroupUsers = GroupHasUser::get()->pluck('user_id')->toArray();
            return view('admin.sections.setup-group.user.create',compact(
                'page_title',
                'transaction_charges',
                'allUsers',
                'assignedGroupUsers'
            ));
        }
        public function storeUserGroup(Request $request){
            $validator = Validator::make($request->all(),[
                'group_name'       => "required|string|max:255",
                'users'       => "required",
            ]);
            if($validator->fails()) return back()->withErrors($validator)->withInput();
            $slugs = TransactionSetting::where('type',GlobalConst::USER)->pluck('slug','title')->toArray();
            $basic_fields = [
                "fixed_charge" => "required",
                "percent_charge" =>  "required",
                "min_limit" =>  "required",
                "max_limit" =>  "required",
                "agent_fixed_commissions" =>  "sometimes|required|numeric",
                "agent_percent_commissions" =>  "sometimes|required|numeric",
                "agent_profit" =>  "sometimes|required|numeric",
            ];
            $admin = auth()->user();
            $group_slug = Str::slug($request->group_name);
            $make_unique = SetupUserGroup::where('slug',$group_slug)->where('type',0)->first();
            if($make_unique){
                return back()->with(['error' => [__("This group already created")]]);
            }
            // create group
            $gp['name'] = $request->group_name;
            $gp['type'] = 0;
            $gp['slug'] =  $group_slug;
            $gp['last_edit_by'] = $admin->id;
            $group = SetupUserGroup::create($gp);
            //============Assign user to group==================
            foreach($request->users as $user){
                $userAssign = new GroupHasUser();
                $userAssign->group_id =  $group->id;
                $userAssign->user_id = $user;
                $userAssign->save();
            }
            $data = [];
            foreach( $slugs  as $title =>  $slug){
                $make_validation_rules  = [];
                foreach($basic_fields as $field => $rule) {
                    $make_validation_rules[$slug."_".$field] = $rule;
                }
                 //Validate
                $validated = Validator::make($request->all(), $make_validation_rules);
                if($validated->fails()){
                    $group->delete();
                }
                $validated = Validator::make($request->all(), $make_validation_rules)->validate();
                foreach($validated as $request_item => $value) {
                    $request_item_array = explode('_',$request_item);
                    $request_item_first = $request_item_array[0] ?? "";
                    if($request_item_first == $slug) {
                        $remove_string = $request_item_first . "_";
                        $column_name =  str_replace($remove_string,"",$request_item);
                        $data[$slug][$column_name] = $value;
                    }

                }
                $data[$slug]['slug'] = Str::slug($slug);
                $data[$slug]['title'] = $title;
                $data[$slug]['group_id'] = $group->id;
                $data[$slug]['admin_id'] = $admin->id;
                $data[$slug]['created_at'] = now();

            }
            $get_data_values = array_values($data);

            try{
                GroupHasTransactionCharge::insert($get_data_values);
            }catch(Exception $e) {
                return back()->with(['error' => [__("Something went wrong! Please try again.")]]);
            }
            return redirect()->route('admin.setup.group.users.index')->with(['success' => [__('User Group Created Successfully!')]]);
        }
        public function editUserGroup($id){
            $page_title = __("Edit Group");
            $group = SetupUserGroup::findOrFail($id);
            $allUsers = User::active()->get();
            $assignedGroupUsers = GroupHasUser::where('group_id',$group->id)->get()->pluck('user_id')->toArray();
            $assignedGroupUsersOther = GroupHasUser::where('group_id','!=',$group->id)->get()->pluck('user_id')->toArray();
            $transaction_charges = GroupHasTransactionCharge::where('group_id',$group->id)->get();
            return view('admin.sections.setup-group.user.edit',compact(
                'page_title',
                'group',
                'transaction_charges',
                'allUsers',
                'assignedGroupUsers',
                'assignedGroupUsersOther'
            ));
        }
        public function updateUserGroup(Request $request){

            $validator = Validator::make($request->all(),[
                'group_name'       => "required|string|max:255",
                'users'       => "required",
            ]);

            if($validator->fails()) return back()->withErrors($validator)->withInput();
            $group = SetupUserGroup::where('id',$request->group_id)->first();
            $slugData = Str::slug($request->group_name);

            $make_unique = SetupUserGroup::where('id','!=', $group->id)->where('slug', $slugData)->where('type',0)->first();

            if($make_unique){
                return back()->with(['error' => [__("This group already created")]]);
            }
            $group->name = $request->group_name;
            $group->slug = Str::slug($request->group_name);
            $group->type = 0;
            $group->last_edit_by = auth()->user()->id;
            $group->save();


            try{
                //============assin user to group==================
            $assignedGroupUsers = GroupHasUser::where('group_id',$group->id)->get();
            if(isset($assignedGroupUsers)){
                foreach( $assignedGroupUsers as $assained){
                    $assained->delete();
                }
            }

            foreach($request->users as $user){
                $userAssign = new GroupHasUser();
                $userAssign->group_id =  $group->id;
                $userAssign->user_id = $user;
                $userAssign->save();
            }
            }catch(Exception $e) {
                return back()->with(['error' => [__("Something went wrong! Please try again.")]]);
            }
            return redirect()->route('admin.setup.group.users.index')->with(['success' => [__('User Group Updated Successfully!')]]);

        }
        public function userGroupTransactionUpdate(Request $request) {
            $group = SetupUserGroup::where('id',$request->group_id)->first();
            $transaction_setting = GroupHasTransactionCharge::where('group_id',$group->id)->where('slug',$request->slug)->first();
            if($transaction_setting->agent_profit == true){
                $agent_percent_commission   = 'required|numeric';
                $agent_fixed_commission     = 'required|numeric';
            }else{
                $agent_percent_commission   = 'sometimes|required|numeric';
                $agent_fixed_commission     = 'sometimes|required|numeric';
            }
            $validator = Validator::make($request->all(),[
                'slug'                                          => 'required|string',
                $request->slug.'_fixed_charge'                  => 'required|numeric',
                $request->slug.'_percent_charge'                => 'required|numeric',
                $request->slug.'_min_limit'                     => 'required|numeric',
                $request->slug.'_max_limit'                     => 'required|numeric',
                $request->slug.'_daily_limit'                   => 'sometimes|required|numeric',
                $request->slug.'_monthly_limit'                 => 'sometimes|required|numeric',
                $request->slug.'_agent_percent_commissions'      => $agent_percent_commission,
                $request->slug.'_agent_fixed_commissions'        => $agent_fixed_commission,
            ]);
            $validated = $validator->validate();


            if(!$transaction_setting) return back()->with(['error' => [__('Transaction charge not found!')]]);
            $validated = replace_array_key($validated,$request->slug."_");

            try{
                $transaction_setting->update($validated);
            }catch(Exception $e) {
                return back()->with(['error' => [__("Something went wrong! Please try again.")]]);
            }

            return back()->with(['success' => [__("Charge Updated Successfully!")]]);

        }
        public function userGroupStatusUpdate(Request $request) {
            $validator = Validator::make($request->all(),[
                'status'                    => 'required|boolean',
                'data_target'               => 'required|string',
            ]);
            if ($validator->stopOnFirstFailure()->fails()) {
                $error = ['error' => $validator->errors()];
                return Response::error($error,null,400);
            }
            $validated = $validator->safe()->all();
            $category_id = $validated['data_target'];

            $group = SetupUserGroup::where('id',$category_id)->first();
            if(!$group) {
                $error = ['error' => [__("Group record not found in our system.")]];
                return Response::error($error,null,404);
            }

            try{
                $group->update([
                    'status' => ($validated['status'] == true) ? false : true,
                ]);
            }catch(Exception $e) {
                $error = ['error' => [__("Something went wrong! Please try again.")]];
                return Response::error($error,null,500);
            }

            $success = ['success' => [__("Group status updated successfully!")]];
            return Response::success($success,null,200);
        }
        public function userGroupDelete(Request $request) {
            $validator = Validator::make($request->all(),[
                'target'        => 'required|string|exists:setup_user_groups,id',
            ]);
            $validated = $validator->validate();
            $category = SetupUserGroup::where("id",$validated['target'])->first();

            try{
                $category->delete();
            }catch(Exception $e) {
                return back()->with(['error' => [__("Something went wrong! Please try again.")]]);
            }

            return back()->with(['success' => [__('Group deleted successfully!')]]);
        }
        public function userGroupSearch(Request $request) {
            $validator = Validator::make($request->all(),[
                'text'  => 'required|string',
            ]);

            if($validator->fails()) {
                $error = ['error' => $validator->errors()];
                return Response::error($error,null,400);
            }

            $validated = $validator->validate();

            $allGroups = SetupUserGroup::user()->search($validated['text'])->select()->limit(10)->get();
            return view('admin.components.search.group-search',compact(
                'allGroups',
            ));
        }
    //==========================================User Group Setup End==========================================

    //==========================================Agent Group Setup=============================================
        public function agentGroups(){
            $page_title = __("Setup Group Agents");
            $allGroups = SetupUserGroup::agent()->paginate(10);
            return view('admin.sections.setup-group.agent.index',compact(
                'page_title',
                'allGroups',
            ));

        }
        public function createAgentGroup(){
            $page_title = __("Create Group");
            $transaction_charges = TransactionSetting::where('type',GlobalConst::AGENT)->get();
            $allAgents = Agent::active()->get();
            $assignedGroupAgents = GroupHasAgent::get()->pluck('agent_id')->toArray();
            return view('admin.sections.setup-group.agent.create',compact(
                'page_title',
                'allAgents',
                'assignedGroupAgents',
                'transaction_charges'
            ));
        }
        public function storeAgentGroup(Request $request){
            $validator = Validator::make($request->all(),[
                'group_name'       => "required|string|max:255",
                'agents'       => "required",
            ]);
            if($validator->fails()) return back()->withErrors($validator)->withInput();
            $slugs = TransactionSetting::where('type',GlobalConst::AGENT)->pluck('slug','title')->toArray();
            $basic_fields = [
                "fixed_charge" => "required",
                "percent_charge" =>  "required",
                "min_limit" =>  "required",
                "max_limit" =>  "required",
                "agent_fixed_commissions" =>  "required|required|numeric",
                "agent_percent_commissions" =>  "required|required|numeric",
                "agent_profit" =>  "sometimes|required|numeric",
            ];
            $admin = auth()->user();
            $group_slug = Str::slug($request->group_name);
            $make_unique = SetupUserGroup::where('slug',$group_slug)->where('type',1)->first();
            if($make_unique){
                return back()->with(['error' => [__("This group already created")]]);
            }
            // create group
            $gp['name'] = $request->group_name;
            $gp['type'] = 1;
            $gp['slug'] =  $group_slug;
            $gp['last_edit_by'] = $admin->id;
            $group = SetupUserGroup::create($gp);
            //============assin agent to group==================
            foreach($request->agents as $agent){
                $userAssign = new GroupHasAgent();
                $userAssign->group_id =  $group->id;
                $userAssign->agent_id = $agent;
                $userAssign->save();
            }
            $data = [];
                foreach( $slugs  as $title =>  $slug){
                    $make_validation_rules  = [];
                    foreach($basic_fields as $field => $rule) {
                        $make_validation_rules[$slug."_".$field] = $rule;
                    }
                    //Validate
                    $validated = Validator::make($request->all(), $make_validation_rules);
                    if($validated->fails()){
                        $group->delete();
                    }
                    $validated = Validator::make($request->all(), $make_validation_rules)->validate();
                    foreach($validated as $request_item => $value) {
                        $request_item_array = explode('_',$request_item);
                        $request_item_first = $request_item_array[0] ?? "";
                        if($request_item_first == $slug) {
                            $remove_string = $request_item_first . "_";
                            $column_name =  str_replace($remove_string,"",$request_item);
                            $data[$slug][$column_name] = $value;
                        }

                    }
                    $data[$slug]['slug'] = Str::slug($slug);
                    $data[$slug]['title'] = $title;
                    $data[$slug]['group_id'] = $group->id;
                    $data[$slug]['admin_id'] = $admin->id;
                    $data[$slug]['created_at'] = now();

                }
                $get_data_values = array_values($data);
            try{
                GroupHasTransactionCharge::insert( $get_data_values);
            }catch(Exception $e) {
                return back()->with(['error' => [__("Something went wrong! Please try again.")]]);
            }
            return redirect()->route('admin.setup.group.agents.index')->with(['success' => [__('Agent Group Created Successfully!')]]);
        }
        public function editAgentGroup($id){
            $page_title = __("Edit Group");
            $group = SetupUserGroup::agent()->findOrFail($id);
            $allAgents = Agent::active()->get();
            $assignedGroupAgent = GroupHasAgent::where('group_id',$group->id)->get()->pluck('agent_id')->toArray();
            $assignedGroupAgentOther = GroupHasAgent::where('group_id','!=',$group->id)->get()->pluck('agent_id')->toArray();
            $transaction_charges = GroupHasTransactionCharge::where('group_id',$group->id)->get();

            return view('admin.sections.setup-group.agent.edit',compact(
                'page_title',
                'group',
                'transaction_charges',
                'allAgents',
                'assignedGroupAgent',
                'assignedGroupAgentOther',
            ));
        }
        public function updateAgentGroup(Request $request){
            $validator = Validator::make($request->all(),[
                'group_name'       => "required|string|max:255",
                'agents'       => "required",
            ]);
            if($validator->fails()) return back()->withErrors($validator)->withInput();
            $group = SetupUserGroup::agent()->where('id',$request->group_id)->first();
            $slugData = Str::slug($request->group_name);
            $make_unique = SetupUserGroup::agent()->where('id','!=', $group->id)->where('slug', $slugData)->first();
            if($make_unique){
                return back()->with(['error' => [__("This group already created")]]);
            }
            $group->name = $request->group_name;
            $group->slug = Str::slug($request->group_name);
            $group->type = 1;
            $group->last_edit_by = auth()->user()->id;
            $group->save();


            try{
                //============assin user to group==================
            $assignedGroupUsers = GroupHasAgent::where('group_id',$group->id)->get();
            if(isset($assignedGroupUsers)){
                foreach( $assignedGroupUsers as $assained){
                    $assained->delete();
                }
            }

            foreach($request->agents as $agent){
                $userAssign = new GroupHasAgent();
                $userAssign->group_id =  $group->id;
                $userAssign->agent_id = $agent;
                $userAssign->save();
            }
            }catch(Exception $e) {
                return back()->with(['error' => [__("Something went wrong! Please try again.")]]);
            }
            return redirect()->route('admin.setup.group.agents.index')->with(['success' => [__('Agent Group Updated Successfully!')]]);

        }
        public function agentGroupTransactionUpdate(Request $request) {

            $group = SetupUserGroup::agent()->where('id',$request->group_id)->first();
            if(!$group){
                return back()->with(['error' => [__("Group not found")]]);
            }
            $transaction_setting = GroupHasTransactionCharge::where('group_id', $group->id)->where('slug',$request->slug)->first();
            if(!$transaction_setting){
                return back()->with(['error' => [__("Transaction not found")]]);
            }
            if($transaction_setting->agent_profit == true){
                $agent_percent_commission   = 'required|numeric';
                $agent_fixed_commission     = 'required|numeric';
            }else{
                $agent_percent_commission   = 'sometimes|required|numeric';
                $agent_fixed_commission     = 'sometimes|required|numeric';
            }

            $validator = Validator::make($request->all(),[
                'slug'                                          => 'required|string',
                $request->slug.'_fixed_charge'                  => 'required|numeric',
                $request->slug.'_percent_charge'                => 'required|numeric',
                $request->slug.'_min_limit'                     => 'required|numeric',
                $request->slug.'_max_limit'                     => 'required|numeric',
                $request->slug.'_daily_limit'                   => 'sometimes|required|numeric',
                $request->slug.'_monthly_limit'                 => 'sometimes|required|numeric',
                $request->slug.'_agent_percent_commissions'      => $agent_percent_commission,
                $request->slug.'_agent_fixed_commissions'        => $agent_fixed_commission,
            ]);
            if($validator->fails()) return back()->withErrors($validator)->withInput();
            $validated = $validator->validate();
            $validated = replace_array_key($validated,$request->slug."_");
            try{
                $transaction_setting->update($validated);
            }catch(Exception $e) {
                return back()->with(['error' => [__("Something went wrong! Please try again.")]]);
            }

            return back()->with(['success' => [__("Charge Updated Successfully!")]]);

        }
        public function agentGroupStatusUpdate(Request $request) {
            $validator = Validator::make($request->all(),[
                'status'                    => 'required|boolean',
                'data_target'               => 'required|string',
            ]);
            if ($validator->stopOnFirstFailure()->fails()) {
                $error = ['error' => $validator->errors()];
                return Response::error($error,null,400);
            }
            $validated = $validator->safe()->all();
            $category_id = $validated['data_target'];

            $group = SetupUserGroup::agent()->where('id',$category_id)->first();
            if(!$group) {
                $error = ['error' => [__("Charge Updated Successfully!")]];
                return Response::error($error,null,404);
            }
            try{
                $group->update([
                    'status' => ($validated['status'] == true) ? false : true,
                ]);
            }catch(Exception $e) {
                $error = ['error' => [__("Something went wrong! Please try again.")]];
                return Response::error($error,null,500);
            }

            $success = ['success' => [__("Group status updated successfully!")]];
            return Response::success($success,null,200);
        }
        public function agentGroupDelete(Request $request) {
            $validator = Validator::make($request->all(),[
                'target'        => 'required|string|exists:setup_user_groups,id',
            ]);
            $validated = $validator->validate();
            $category = SetupUserGroup::agent()->where("id",$validated['target'])->first();

            try{
                $category->delete();
            }catch(Exception $e) {
                return back()->with(['error' => [__("Something went wrong! Please try again.")]]);
            }

            return back()->with(['success' => [__('Group deleted successfully!')]]);
        }
        public function agentGroupSearch(Request $request) {
            $validator = Validator::make($request->all(),[
                'text'  => 'required|string',
            ]);

            if($validator->fails()) {
                $error = ['error' => $validator->errors()];
                return Response::error($error,null,400);
            }

            $validated = $validator->validate();

            $allGroups = SetupUserGroup::agent()->search($validated['text'])->select()->limit(10)->get();
            return view('admin.components.search.agent-group-search',compact(
                'allGroups',
            ));
        }
    //==========================================Merchant Group Setup=============================================
        public function merchantGroups(){
            $page_title = __("Setup Group Merchants");
            $allGroups = SetupUserGroup::merchant()->paginate(10);
            return view('admin.sections.setup-group.merchant.index',compact(
                'page_title',
                'allGroups',
            ));

        }
        public function createMerchantGroup(){
            $page_title = __("Create Group");
            $transaction_charges = TransactionSetting::where('type',GlobalConst::MERCHANT)->get();
            $allMerchants = Merchant::active()->get();
            $assignedGroupMerchant = GroupHasMerchant::get()->pluck('merchant_id')->toArray();
            return view('admin.sections.setup-group.merchant.create',compact(
                'page_title',
                'allMerchants',
                'assignedGroupMerchant',
                'transaction_charges'
            ));
        }
        public function storeMerchantGroup(Request $request){
            $validator = Validator::make($request->all(),[
                'group_name'        => "required|string|max:255",
                'merchants'         => "required",
            ]);
            if($validator->fails()) return back()->withErrors($validator)->withInput();
            $slugs = TransactionSetting::where('type',GlobalConst::MERCHANT)->pluck('slug','title')->toArray();
            $basic_fields = [
                "fixed_charge" => "required",
                "percent_charge" =>  "required",
                "min_limit" =>  "required",
                "max_limit" =>  "required",
                "agent_fixed_commissions" =>  "sometimes|required|numeric",
                "agent_percent_commissions" =>  "sometimes|required|numeric",
                "agent_profit" =>  "sometimes|required|numeric",
            ];
            $admin = auth()->user();
            $group_slug = Str::slug($request->group_name);
            $make_unique = SetupUserGroup::where('slug',$group_slug)->where('type',2)->first();
            if($make_unique){
                return back()->with(['error' => [__("This group already created")]]);
            }
            // create group
            $gp['name'] = $request->group_name;
            $gp['type'] = 2;
            $gp['slug'] =  $group_slug;
            $gp['last_edit_by'] = $admin->id;
            $group = SetupUserGroup::create($gp);
            //============Assign merchant to group==================
            foreach($request->merchants as $merchant){
                $userAssign = new GroupHasMerchant();
                $userAssign->group_id =  $group->id;
                $userAssign->merchant_id = $merchant;
                $userAssign->save();
            }
            $data = [];
                foreach( $slugs  as $title =>  $slug){
                    $make_validation_rules  = [];
                    foreach($basic_fields as $field => $rule) {
                        $make_validation_rules[$slug."_".$field] = $rule;
                    }
                    //Validate
                    $validated = Validator::make($request->all(), $make_validation_rules);
                    if($validated->fails()){
                        $group->delete();
                    }
                    $validated = Validator::make($request->all(), $make_validation_rules)->validate();
                    foreach($validated as $request_item => $value) {
                        $request_item_array = explode('_',$request_item);
                        $request_item_first = $request_item_array[0] ?? "";
                        if($request_item_first == $slug) {
                            $remove_string = $request_item_first . "_";
                            $column_name =  str_replace($remove_string,"",$request_item);
                            $data[$slug][$column_name] = $value;
                        }

                    }
                    $data[$slug]['slug'] = Str::slug($slug);
                    $data[$slug]['title'] = $title;
                    $data[$slug]['group_id'] = $group->id;
                    $data[$slug]['admin_id'] = $admin->id;
                    $data[$slug]['created_at'] = now();

                }
                $get_data_values = array_values($data);
            try{
                GroupHasTransactionCharge::insert( $get_data_values);
            }catch(Exception $e) {
                return back()->with(['error' => [__("Something went wrong! Please try again.")]]);
            }
            return redirect()->route('admin.setup.group.merchants.index')->with(['success' => [__('Merchant Group Created Successfully!')]]);
        }
        public function editMerchantGroup($id){
            $page_title = __("Edit Group");
            $group = SetupUserGroup::merchant()->findOrFail($id);
            $allMerchants = Merchant::active()->get();
            $assignedGroupMerchant = GroupHasMerchant::where('group_id',$group->id)->get()->pluck('merchant_id')->toArray();
            $assignedGroupMerchantOther = GroupHasMerchant::where('group_id','!=',$group->id)->get()->pluck('merchant_id')->toArray();
            $transaction_charges = GroupHasTransactionCharge::where('group_id',$group->id)->get();
            return view('admin.sections.setup-group.merchant.edit',compact(
                'page_title',
                'group',
                'transaction_charges',
                'allMerchants',
                'assignedGroupMerchant',
                'assignedGroupMerchantOther',
            ));
        }
        public function updateMerchantGroup(Request $request){
            $validator = Validator::make($request->all(),[
                'group_name'        => "required|string|max:255",
                'merchants'         => "required",
            ]);
            if($validator->fails()) return back()->withErrors($validator)->withInput();
            $group = SetupUserGroup::merchant()->where('id',$request->group_id)->first();
            $slugData = Str::slug($request->group_name);
            $make_unique = SetupUserGroup::merchant()->where('id','!=', $group->id)->where('slug', $slugData)->first();
            if($make_unique){
                return back()->with(['error' => [__("This group already created")]]);
            }
            $group->name = $request->group_name;
            $group->slug = Str::slug($request->group_name);
            $group->type = 2;
            $group->last_edit_by = auth()->user()->id;
            $group->save();

            try{
                //============assin user to group==================
            $assignedGroupUsers = GroupHasMerchant::where('group_id',$group->id)->get();
            if(isset($assignedGroupUsers)){
                foreach( $assignedGroupUsers as $assained){
                    $assained->delete();
                }
            }

            foreach($request->merchants as $merchant){
                $userAssign = new GroupHasMerchant();
                $userAssign->group_id =  $group->id;
                $userAssign->merchant_id = $merchant;
                $userAssign->save();
            }
            }catch(Exception $e) {
                return back()->with(['error' => [__("Something went wrong! Please try again.")]]);
            }
            return redirect()->route('admin.setup.group.merchants.index')->with(['success' => [__('Merchant Group Updated Successfully!')]]);

        }
        public function merchantGroupTransactionUpdate(Request $request) {
            $group = SetupUserGroup::merchant()->where('id',$request->group_id)->first();
            if(!$group){
                return back()->with(['error' => ["Group not found"]]);
            }
            $transaction_setting = GroupHasTransactionCharge::where('group_id',$group->id)->where('slug',$request->slug)->first();
            if(!$transaction_setting){
                return back()->with(['error' => [__("Transaction not found")]]);
            }
            if($transaction_setting->agent_profit == true){
                $agent_percent_commission   = 'required|numeric';
                $agent_fixed_commission     = 'required|numeric';
            }else{
                $agent_percent_commission   = 'sometimes|required|numeric';
                $agent_fixed_commission     = 'sometimes|required|numeric';
            }

            $validator = Validator::make($request->all(),[
                'slug'                                          => 'required|string',
                $request->slug.'_fixed_charge'                  => 'required|numeric',
                $request->slug.'_percent_charge'                => 'required|numeric',
                $request->slug.'_min_limit'                     => 'required|numeric',
                $request->slug.'_max_limit'                     => 'required|numeric',
                $request->slug.'_daily_limit'                   => 'sometimes|required|numeric',
                $request->slug.'_monthly_limit'                 => 'sometimes|required|numeric',
                $request->slug.'_agent_percent_commissions'     => $agent_percent_commission,
                $request->slug.'_agent_fixed_commissions'       => $agent_fixed_commission,
            ]);
            if($validator->fails()) return back()->withErrors($validator)->withInput();
            $validated = $validator->validate();
            $validated = replace_array_key($validated,$request->slug."_");
            try{
                $transaction_setting->update($validated);
            }catch(Exception $e) {
                return back()->with(['error' => [__("Something went wrong! Please try again.")]]);
            }
            return back()->with(['success' => [__("Charge Updated Successfully!")]]);
        }
        public function merchantGroupStatusUpdate(Request $request) {
            $validator = Validator::make($request->all(),[
                'status'                    => 'required|boolean',
                'data_target'               => 'required|string',
            ]);
            if ($validator->stopOnFirstFailure()->fails()) {
                $error = ['error' => $validator->errors()];
                return Response::error($error,null,400);
            }
            $validated = $validator->safe()->all();
            $category_id = $validated['data_target'];

            $group = SetupUserGroup::merchant()->where('id',$category_id)->first();
            if(!$group) {
                $error = ['error' => [__("Charge Updated Successfully!")]];
                return Response::error($error,null,404);
            }
            try{
                $group->update([
                    'status' => ($validated['status'] == true) ? false : true,
                ]);
            }catch(Exception $e) {
                $error = ['error' => [__("Something went wrong! Please try again.")]];
                return Response::error($error,null,500);
            }

            $success = ['success' => [__("Group status updated successfully!")]];
            return Response::success($success,null,200);
        }
        public function merchantGroupDelete(Request $request) {
            $validator = Validator::make($request->all(),[
                'target'        => 'required|string|exists:setup_user_groups,id',
            ]);
            $validated = $validator->validate();
            $category = SetupUserGroup::merchant()->where("id",$validated['target'])->first();

            try{
                $category->delete();
            }catch(Exception $e) {
                return back()->with(['error' => [__("Something went wrong! Please try again.")]]);
            }
            return back()->with(['success' => [__('Group deleted successfully!')]]);
        }
        public function merchantGroupSearch(Request $request) {
            $validator = Validator::make($request->all(),[
                'text'  => 'required|string',
            ]);

            if($validator->fails()) {
                $error = ['error' => $validator->errors()];
                return Response::error($error,null,400);
            }

            $validated = $validator->validate();

            $allGroups = SetupUserGroup::merchant()->search($validated['text'])->select()->limit(10)->get();
            return view('admin.components.search.merchant-group-search',compact(
                'allGroups',
            ));
        }
}
